/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.project.AdditionalActionsProvider;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.ActionProviderImpl;
import org.mevenide.netbeans.project.exec.RunGoalsAction;
import org.mevenide.netbeans.project.nodes.MavenProjectChildren;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class MavenProjectNode
extends AbstractNode {
    private static Log log = LogFactory.getLog((Class)MavenProjectNode.class);
    private MavenProject project;
    private ProjectInformation info;
    private Image icon;

    public MavenProjectNode(Lookup lookup, MavenProject proj) {
        super((Children)new MavenProjectChildren(proj), lookup);
        this.project = proj;
        this.info = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        this.project.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                MavenProjectNode.this.fireDisplayNameChange(null, MavenProjectNode.this.getDisplayName());
                MavenProjectNode.this.fireIconChange();
            }
        });
    }

    public String getDisplayName() {
        return this.project.getDisplayName();
    }

    public Image getIcon(int param) {
        Image img = ((ImageIcon)this.info.getIcon()).getImage();
        FileObject fo = this.project.getProjectDirectory();
        try {
            img = fo.getFileSystem().getStatus().annotateIcon(img, param, Collections.singleton(fo));
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return img;
    }

    public Image getOpenedIcon(int param) {
        Image img = ((ImageIcon)this.info.getIcon()).getImage();
        FileObject fo = this.project.getProjectDirectory();
        try {
            img = fo.getFileSystem().getStatus().annotateIcon(img, param, Collections.singleton(fo));
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return img;
    }

    public Action[] getActions(boolean param) {
        boolean hasCompile = this.project.getPropertyResolver().getResolvedValue("maven.netbeans.exec.compile.single") != null;
        boolean isMultiproject = this.project.getPropertyLocator().getPropertyLocation("maven.multiproject.includes") > -2;
        ArrayList<Action> lst = new ArrayList<Action>();
        ActionProviderImpl provider = (ActionProviderImpl)this.project.getLookup().lookup(ActionProviderImpl.class);
        lst.add(CommonProjectActions.newFileAction());
        lst.add(null);
        lst.add(provider.createBasicMavenAction("Build", "build"));
        lst.add(provider.createBasicMavenAction("Rebuild", "rebuild"));
        lst.add(provider.createBasicMavenAction("Clean", "clean"));
        lst.add(provider.createBasicMavenAction("Generate Javadoc", "javadoc"));
        if (isMultiproject) {
            lst.add(provider.createBasicMavenAction("Build (multiproject)", "multiprojectbuild"));
            lst.add(provider.createBasicMavenAction("Clean (multiproject)", "multiprojectclean"));
        }
        Lookup.Result res = Lookup.getDefault().lookup(new Lookup.Template(AdditionalActionsProvider.class));
        Iterator it = res.allInstances().iterator();
        while (it.hasNext()) {
            AdditionalActionsProvider act = (AdditionalActionsProvider)it.next();
            Action[] acts = act.createPopupActions(this.project);
            lst.addAll(Arrays.asList(acts));
        }
        lst.add(new RunGoalsAction(this.project));
        lst.add(null);
        lst.add(this.project.createRefreshAction());
        lst.add(CommonProjectActions.setAsMainProjectAction());
        lst.add(CommonProjectActions.openSubprojectsAction());
        lst.add(CommonProjectActions.closeProjectAction());
        lst.add(null);
        lst.add((Action)SystemAction.get((Class)FindAction.class));
        try {
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Projects/Actions");
            if (fo != null) {
                DataObject dobj = DataObject.find((FileObject)fo);
                FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                Lookup.Template query = new Lookup.Template(Object.class);
                Lookup lookup = actionRegistry.getLookup();
                Iterator it2 = lookup.lookup(query).allInstances().iterator();
                if (it2.hasNext()) {
                    lst.add(null);
                }
                while (it2.hasNext()) {
                    Object next = it2.next();
                    if (next instanceof Action) {
                        lst.add((Action)next);
                        continue;
                    }
                    if (!(next instanceof JSeparator)) continue;
                    lst.add(null);
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        lst.add(null);
        lst.add((Action)SystemAction.get((Class)ToolsAction.class));
        lst.add(null);
        lst.add(CommonProjectActions.customizeProjectAction());
        return lst.toArray(new Action[lst.size()]);
    }

    public String getShortDescription() {
        return this.project.getShortDescription();
    }
}

