/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.output;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.output.AbstractOutputProcessor;
import org.mevenide.netbeans.api.output.OutputVisitor;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.output.CheckstyleAnnotation;
import org.mevenide.reports.CheckstyleResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class CheckstyleOutputListenerProvider
extends AbstractOutputProcessor {
    private static final Log logger = LogFactory.getLog((Class)CheckstyleOutputListenerProvider.class);
    private static final String[] CHECKSTYLEGOALS = new String[]{"checkstyle:run:"};
    private Pattern failPattern = Pattern.compile("checkstyle\\:run\\:");
    private MavenProject project;

    public CheckstyleOutputListenerProvider(MavenProject proj) {
        this.project = proj;
    }

    public String[] getWatchedGoals() {
        return CHECKSTYLEGOALS;
    }

    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.isInWatchedGoals(line) && (match = this.failPattern.matcher(line)).matches()) {
            visitor.setOutputListener(new CheckStyleOutputListener(this.project));
        }
    }

    private static class CheckStyleOutputListener
    implements OutputListener {
        private MavenProject project;

        public CheckStyleOutputListener(MavenProject proj) {
            this.project = proj;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            this.openReport();
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openReport() {
            CheckstyleResult result = new CheckstyleResult(this.project.getContext());
            String title = "Checkstyle: " + this.project.getDisplayName();
            try {
                IOProvider.getDefault().getIO(title, false).getOut().reset();
            }
            catch (Exception exc) {
                logger.error((Object)"Exception while resetting output", (Throwable)exc);
            }
            InputOutput io = IOProvider.getDefault().getIO(title, false);
            io.select();
            OutputWriter writer = io.getOut();
            try {
                File[] files = result.getFiles();
                File srcRoot = new File(this.project.getSrcDirectory());
                FileObject rootFo = FileUtil.toFileObject((File)srcRoot);
                if (files.length == 0) {
                    writer.println("No files violating the defined checkstyle rules.");
                } else {
                    writer.println("Number of violating files: " + files.length);
                    writer.println(" ");
                }
                for (int i = 0; i < files.length; ++i) {
                    FileObject file = FileUtil.toFileObject((File)files[i]);
                    String relative = FileUtil.getRelativePath((FileObject)rootFo, (FileObject)file);
                    relative = relative == null ? files[i].toString() : relative.replace('\\', '/').replace('/', '.');
                    writer.println(relative);
                    List viols = result.getViolationsForFile(files[i]);
                    Iterator it = viols.iterator();
                    while (it.hasNext()) {
                        CheckstyleResult.Violation v = (CheckstyleResult.Violation)it.next();
                        CheckstyleAnnotation list = new CheckstyleAnnotation(v);
                        writer.println("   Line:" + v.getLine() + " " + v.getMessage(), (OutputListener)list);
                    }
                    writer.println(" ");
                }
            }
            catch (IOException exc) {
                logger.error((Object)"Exception while writing output", (Throwable)exc);
            }
            finally {
                writer.close();
            }
        }
    }
}

