/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class MavenFileOwnerQueryImpl
implements FileOwnerQueryImplementation {
    private static final Log logger = LogFactory.getLog((Class)MavenFileOwnerQueryImpl.class);
    private Set set;
    private Object lock = new Object();
    private Object cacheLock = new Object();
    private List listeners;
    private Set cachedProjects;
    private PropertyChangeListener projectListener;
    static /* synthetic */ Class class$org$netbeans$spi$project$SubprojectProvider;

    public MavenFileOwnerQueryImpl() {
        logger.debug((Object)"MavenFileOwnerQueryImpl()");
        this.set = new HashSet();
        this.listeners = new ArrayList();
        this.cachedProjects = null;
        this.projectListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent evt) {
                Object object = MavenFileOwnerQueryImpl.this.cacheLock;
                synchronized (object) {
                    MavenFileOwnerQueryImpl.this.cachedProjects = null;
                }
            }
        };
    }

    public static MavenFileOwnerQueryImpl getInstance() {
        Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(FileOwnerQueryImplementation.class));
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof MavenFileOwnerQueryImpl) {
                return (MavenFileOwnerQueryImpl)obj;
            }
            logger.debug((Object)("fileOwnwequeryImpl=" + obj.getClass()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMavenProject(MavenProject project) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.set.contains(project)) {
                this.set.add(project);
                project.addPropertyChangeListener(this.projectListener);
            }
        }
        object = this.cacheLock;
        synchronized (object) {
            this.cachedProjects = null;
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProject(MavenProject project) {
        Object object = this.lock;
        synchronized (object) {
            if (this.set.contains(project)) {
                this.set.remove(project);
                project.removePropertyChangeListener(this.projectListener);
            }
        }
        object = this.cacheLock;
        synchronized (object) {
            this.cachedProjects = null;
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener list) {
        List list2 = this.listeners;
        synchronized (list2) {
            this.listeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener list) {
        List list2 = this.listeners;
        synchronized (list2) {
            this.listeners.remove(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList lst = new ArrayList();
        List list = this.listeners;
        synchronized (list) {
            lst.addAll(this.listeners);
        }
        Iterator it = lst.iterator();
        ChangeEvent event = new ChangeEvent(this);
        while (it.hasNext()) {
            ChangeListener change = (ChangeListener)it.next();
            change.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpenedProjects() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet(this.set);
        }
    }

    public Project getOwner(URI uri) {
        File file = new File(uri);
        return this.getOwner(file);
    }

    public Project getOwner(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.getOwner(file);
        }
        return null;
    }

    private Project getOwner(File file) {
        Set currentProjects = this.getAllKnownProjects();
        try {
            IDependencyResolver resolver = DependencyResolverFactory.getFactory().newInstance(file.getAbsolutePath());
            String version = resolver.guessVersion();
            String artifactid = resolver.guessArtifactId();
            String groupid = resolver.guessGroupId();
            Iterator it = currentProjects.iterator();
            while (it.hasNext()) {
                MavenProject project = (MavenProject)it.next();
                org.apache.maven.project.Project proj = project.getOriginalMavenProject();
                IPropertyResolver res = project.getPropertyResolver();
                if (version == null || !"SNAPSHOT".equals(version) && !this.doCompare(version, res.resolveString(proj.getCurrentVersion())) || artifactid == null || !this.doCompare(artifactid, res.resolveString(proj.getArtifactId())) && !this.doCompare(artifactid, res.resolveString(proj.getId())) || groupid == null || !this.doCompare(groupid, res.resolveString(proj.getGroupId())) && !groupid.equals(artifactid)) continue;
                logger.debug((Object)("found project=" + project.getDisplayName()));
                return project;
            }
        }
        catch (Exception exc) {
            logger.error((Object)"Something wrong with resolver.", (Throwable)exc);
        }
        return null;
    }

    private boolean doCompare(String one, String two) {
        if (one == null || two == null) {
            return false;
        }
        return one.trim().equals(two.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getAllKnownProjects() {
        Object object = this.cacheLock;
        synchronized (object) {
            ArrayList iterating;
            HashSet currentProjects;
            if (this.cachedProjects != null) {
                return new HashSet(this.cachedProjects);
            }
            Object object2 = this.lock;
            synchronized (object2) {
                currentProjects = new HashSet(this.set);
                iterating = new ArrayList(this.set);
            }
            for (int index = 0; index < iterating.size(); ++index) {
                MavenProject prj = (MavenProject)iterating.get(index);
                SubprojectProvider sub = (SubprojectProvider)prj.getLookup().lookup(class$org$netbeans$spi$project$SubprojectProvider == null ? MavenFileOwnerQueryImpl.class$("org.netbeans.spi.project.SubprojectProvider") : class$org$netbeans$spi$project$SubprojectProvider);
                Set subs = sub.getSubprojects();
                subs.removeAll(currentProjects);
                currentProjects.addAll(subs);
                iterating.addAll(subs);
            }
            this.cachedProjects = currentProjects;
            return new HashSet(this.cachedProjects);
        }
    }
}

