/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.api.customizer;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.mevenide.context.IProjectContext;
import org.mevenide.netbeans.api.customizer.LocationComboBox;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.FileUtilities;
import org.openide.util.Utilities;

public final class LocationComboFactory {
    private LocationComboFactory() {
    }

    public static OriginChange createPropertiesChange(MavenProject project) {
        LocationComboBox box = new LocationComboBox(false);
        boolean justSingle = true;
        int level = 1;
        IProjectContext pom = project.getContext().getPOMContext();
        if (pom != null) {
            justSingle = pom.getProjectDepth() == 1;
            level = pom.getProjectDepth();
        }
        ArrayList<LocationComboBox.LocationWrapper> col = new ArrayList<LocationComboBox.LocationWrapper>();
        ImageIcon icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocDefault.png"));
        ImageIcon mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToDefault.png"));
        col.add(new LocationComboBox.LocationWrapper("Default value", icon, "Reset to Default", mvIcon, null, -2));
        col.add(new LocationComboBox.LocationWrapper("Default value", icon, null, null, null, -1));
        icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocNotDefined.png"));
        col.add(new LocationComboBox.LocationWrapper("Defined in System Environment Variable", icon, null, null, null, 99));
        icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocUser.png"));
        mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToUser.png"));
        col.add(new LocationComboBox.LocationWrapper("Defined in user's build.properties", icon, "Move to User", mvIcon, FileUtilities.locationToFile(12, project), 12));
        if (level > 0) {
            icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocProject.png"));
            mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToProject.png"));
            col.add(new LocationComboBox.LocationWrapper("Defined in project.properties", icon, "Move to Project", mvIcon, FileUtilities.locationToFile(10, project), 10));
            icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocBuild.png"));
            mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToBuild.png"));
            col.add(new LocationComboBox.LocationWrapper("Defined in build.properties", icon, "Move to Build", mvIcon, FileUtilities.locationToFile(11, project), 11));
        }
        if (level > 1) {
            icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocParentProject.png"));
            mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToParentProject.png"));
            col.add(new LocationComboBox.LocationWrapper("Defined in parent project.properties", icon, "Move to Parent Project", mvIcon, FileUtilities.locationToFile(20, project), 20));
            icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocParentBuild.png"));
            mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToParentBuild.png"));
            col.add(new LocationComboBox.LocationWrapper("Defined in parent build.properties", icon, "Move to Parent Build", mvIcon, FileUtilities.locationToFile(21, project), 21));
        }
        if (level > 2) {
            for (int i = 3; i <= level; ++i) {
                icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocXthParentProject.png"));
                mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToXthParentProject.png"));
                col.add(new LocationComboBox.LocationWrapper("Defined in " + (i - 1) + ". parent project.properties", icon, "Move to " + (i - 1) + "Parent Project", mvIcon, FileUtilities.locationToFile(i * 10 + 0, project), i * 10 + 0));
                icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocXthParentBuild.png"));
                mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToXthParentBuild.png"));
                col.add(new LocationComboBox.LocationWrapper("Defined in " + (i - 1) + ". parent build.properties", icon, "Move to " + (i - 1) + ". Parent Build", mvIcon, FileUtilities.locationToFile(i * 10 + 1, project), i * 10 + 1));
            }
        }
        LocationComboBox.LocationWrapper[] wraps = new LocationComboBox.LocationWrapper[col.size()];
        wraps = col.toArray(wraps);
        box.setItems(wraps);
        return new OriginChange(box);
    }

    public static OriginChange createPOMChange(MavenProject project, boolean showText) {
        LocationComboBox box = new LocationComboBox(showText);
        int poms = project.getContext().getPOMContext().getProjectDepth();
        ArrayList<LocationComboBox.LocationWrapper> col = new ArrayList<LocationComboBox.LocationWrapper>();
        ImageIcon icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocPomFile.png"));
        ImageIcon mvIcon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/ToDefault.png"));
        col.add(new LocationComboBox.LocationWrapper("Defined in project's POM file", icon, "Move to POM", mvIcon, FileUtilities.locationToFile(0, project), 0));
        icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocDefault.png"));
        col.add(new LocationComboBox.LocationWrapper("No defined value", icon, "Remove Definition", mvIcon, null, -1));
        if (poms > 1) {
            icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocParentPOM.png"));
            col.add(new LocationComboBox.LocationWrapper("Defined in POM's parent definition", icon, "Move to Parent", mvIcon, FileUtilities.locationToFile(1, project), 1));
        }
        if (poms > 2) {
            for (int i = 3; i <= poms; ++i) {
                icon = new ImageIcon(Utilities.loadImage((String)"org/mevenide/netbeans/project/resources/LocParParPOM.png"));
                col.add(new LocationComboBox.LocationWrapper("Defined in POM's " + (i - 1) + ". parent definition", icon, "Move to " + (i - 1) + ". Parent", mvIcon, FileUtilities.locationToFile(i - 1, project), i - 1));
            }
        }
        LocationComboBox.LocationWrapper[] wraps = new LocationComboBox.LocationWrapper[col.size()];
        wraps = col.toArray(wraps);
        box.setItems(wraps);
        return new OriginChange(box);
    }
}

