/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.util.List;
import javax.swing.JButton;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.customizer.MavenCustomizer;
import org.mevenide.netbeans.project.writer.NbProjectWriter;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;

public class CustomizerProviderImpl
implements CustomizerProvider {
    private static final String COMMAND_APPLY = "APPLY";
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private MavenProject project;

    public CustomizerProviderImpl(MavenProject projectToCustomize) {
        this.project = projectToCustomize;
    }

    public void showCustomizer() {
        Object[] options = new JButton[]{new JButton("Apply"), new JButton(COMMAND_OK), new JButton("Cancel")};
        options[0].setActionCommand(COMMAND_APPLY);
        options[1].setActionCommand(COMMAND_OK);
        options[2].setActionCommand(COMMAND_CANCEL);
        MavenCustomizer customizer = new MavenCustomizer(this.project);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizer, this.project.getDisplayName(), true, options, (Object)options[1], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[1], options[2]});
        Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (retValue == options[0] || retValue == options[1]) {
            List changes = customizer.getChanges();
            boolean wasError = false;
            try {
                NbProjectWriter writer = new NbProjectWriter(this.project);
                writer.applyChanges(changes);
            }
            catch (Exception exc) {
                ErrorManager.getDefault().notify(256, (Throwable)exc);
                wasError = true;
            }
        }
    }

    private boolean stringsEqual(String one, String two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.trim().equals(two.trim());
    }
}

