/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MavenSettings
extends SystemOption {
    public static final String PROP_TOP_GOALS = "topGoals";
    public static final String PROP_REPOSITORIES = "repositories";
    public static final String PROP_DEP_PROPS = "dependencyProperties";
    public static final String PROP_SHOW_FAVOURITE_HINT = "showAddFavouriteHint";
    public static final String PROP_OFFLINE = "offline";
    public static final String PROP_NOBANNER = "nobanner";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_EXCEPTIONS = "exceptions";
    public static final String PROP_NONVERBOSE = "nonverbose";
    public static final String PROP_DOWNLOADER = "downloader";
    public static final String PROP_MAVEN_HOME = "mavenhome";
    private static final long serialVersionUID = -4857548488373547L;

    protected void initialize() {
        super.initialize();
        String[] defaultGoals = new String[]{"pmd:report", "checkstyle:report", "dist"};
        this.setTopGoals(defaultGoals);
        this.setShowAddFavouriteHint(true);
        this.setOffline(false);
        this.setNoBanner(false);
        this.setNonverbose(false);
        this.setExceptions(false);
        this.setDebug(false);
        this.setMavenHome(null);
        this.setDownloader("silent");
        this.setRepositories(new String[]{"http://www.ibiblio.org/maven/", "http://cvs.apache.org/repository/", "http://maven-plugins.sourceforge.net/maven/", "http://seasar.sourceforge.jp/maven/", "http://spring-ext.sourceforge.jp/maven/", "http://ibiblio.org/geotools", "http://www.codeczar.com/maven/"});
        this.setDependencyProperties(new String[]{"war.bundle", "war.target.path", "netbeans.module.ext", "netbeans.module.dep", "ear.bundle", "ear.bundle.dir", "ear.bundle.name", "ear.module", "ejb.bundle", "ejb.manifest.classpath"});
    }

    public String displayName() {
        return NbBundle.getMessage((Class)MavenSettings.class, (String)"LBL_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.mevenide.netbeans.projects");
    }

    public static MavenSettings getDefault() {
        return (MavenSettings)MavenSettings.findObject((Class)MavenSettings.class, (boolean)true);
    }

    public String[] getTopGoals() {
        return (String[])this.getProperty(PROP_TOP_GOALS);
    }

    public void setTopGoals(String[] topGoals) {
        this.putProperty(PROP_TOP_GOALS, topGoals, true);
    }

    public boolean isShowAddFavouriteHint() {
        Boolean obj = (Boolean)this.getProperty(PROP_SHOW_FAVOURITE_HINT);
        return obj == null ? true : obj;
    }

    public void setShowAddFavouriteHint(boolean showHint) {
        this.putProperty(PROP_SHOW_FAVOURITE_HINT, showHint, true);
    }

    public boolean isOffline() {
        Boolean obj = (Boolean)this.getProperty(PROP_OFFLINE);
        return obj == null ? true : obj;
    }

    public void setOffline(boolean offline) {
        this.putProperty(PROP_OFFLINE, offline, true);
    }

    public boolean isNoBanner() {
        Boolean obj = (Boolean)this.getProperty(PROP_NOBANNER);
        return obj == null ? true : obj;
    }

    public void setNoBanner(boolean nb) {
        this.putProperty(PROP_NOBANNER, nb, true);
    }

    public boolean isDebug() {
        Boolean obj = (Boolean)this.getProperty(PROP_DEBUG);
        return obj == null ? true : obj;
    }

    public void setDebug(boolean debug) {
        this.putProperty(PROP_DEBUG, debug, true);
    }

    public boolean isExceptions() {
        Boolean obj = (Boolean)this.getProperty(PROP_EXCEPTIONS);
        return obj == null ? true : obj;
    }

    public void setExceptions(boolean exc) {
        this.putProperty(PROP_EXCEPTIONS, exc, true);
    }

    public boolean isNonverbose() {
        Boolean obj = (Boolean)this.getProperty(PROP_NONVERBOSE);
        return obj == null ? true : obj;
    }

    public void setNonverbose(boolean nonverbose) {
        this.putProperty(PROP_NONVERBOSE, nonverbose, true);
    }

    public String getDownloader() {
        return (String)this.getProperty(PROP_DOWNLOADER);
    }

    public void setDownloader(String downloader) {
        this.putProperty(PROP_DOWNLOADER, downloader, true);
    }

    public String[] getRepositories() {
        return (String[])this.getProperty(PROP_REPOSITORIES);
    }

    public void setRepositories(String[] repos) {
        this.putProperty(PROP_REPOSITORIES, repos, true);
    }

    public String[] getDependencyProperties() {
        return (String[])this.getProperty(PROP_DEP_PROPS);
    }

    public void setDependencyProperties(String[] repos) {
        this.putProperty(PROP_DEP_PROPS, repos, true);
    }

    public void checkDependencyProperties(Collection newones) {
        ArrayList<String> lst = new ArrayList<String>(Arrays.asList(this.getDependencyProperties()));
        Iterator it = newones.iterator();
        boolean updated = false;
        while (it.hasNext()) {
            Object key = it.next();
            if (lst.contains(key)) continue;
            updated = true;
            lst.add((String)key);
        }
        if (updated) {
            this.setDependencyProperties(lst.toArray(new String[lst.size()]));
        }
    }

    public void setMavenHome(String home) {
        this.putProperty(PROP_MAVEN_HOME, home, true);
    }

    public String getMavenHome() {
        String str = (String)this.getProperty(PROP_MAVEN_HOME);
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str;
    }
}

