/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mevenide.netbeans.api.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class BootClassPathImpl
implements ClassPathImplementation {
    private MavenProject project;
    private List resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String lastNonDefault = null;
    private String lastNonDefaultPlatform = null;

    public BootClassPathImpl(MavenProject proj) {
        this.project = proj;
        this.project.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JavaPlatform[] pms;
                String customCompile = BootClassPathImpl.this.project.getPropertyResolver().getResolvedValue("maven.compile.executable");
                if (customCompile != null && !customCompile.equals(BootClassPathImpl.this.lastNonDefault) || customCompile == null && BootClassPathImpl.this.lastNonDefault != null) {
                    List oldValue = BootClassPathImpl.this.resourcesCache;
                    BootClassPathImpl.this.resourcesCache = null;
                    List newValue = BootClassPathImpl.this.getResources();
                    BootClassPathImpl.this.support.firePropertyChange("resources", oldValue, newValue);
                }
                if (BootClassPathImpl.this.lastNonDefaultPlatform != null && (pms = JavaPlatformManager.getDefault().getPlatforms(BootClassPathImpl.this.lastNonDefaultPlatform, null)).length == 0) {
                    List oldValue = BootClassPathImpl.this.resourcesCache;
                    BootClassPathImpl.this.resourcesCache = null;
                    List newValue = BootClassPathImpl.this.getResources();
                    BootClassPathImpl.this.support.firePropertyChange("resources", oldValue, newValue);
                }
            }
        });
    }

    public synchronized List getResources() {
        JavaPlatform jp;
        if (this.resourcesCache == null && (jp = this.findActivePlatform()) != null) {
            ClassPath cp = jp.getBootstrapLibraries();
            List entries = cp.entries();
            ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>(entries.size());
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)it.next();
                result.add(ClassPathSupport.createResource((URL)entry.getURL()));
            }
            this.resourcesCache = Collections.unmodifiableList(result);
        }
        return this.resourcesCache;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private JavaPlatform findActivePlatform() {
        FileObject toolFO;
        JavaPlatformManager pm = JavaPlatformManager.getDefault();
        String customCompile = this.project.getPropertyResolver().getResolvedValue("maven.compile.executable");
        if (customCompile != null && (toolFO = FileUtil.toFileObject((File)new File(customCompile))) != null) {
            String toolname = toolFO.getNameExt();
            JavaPlatform[] platforms = pm.getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                FileObject fo = platforms[i].findTool(toolname);
                if (fo == null || !fo.equals(toolFO)) continue;
                this.lastNonDefault = customCompile;
                this.lastNonDefaultPlatform = platforms[i].getDisplayName();
                return platforms[i];
            }
        }
        this.lastNonDefault = null;
        this.lastNonDefaultPlatform = null;
        return pm.getDefaultPlatform();
    }
}

