/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.customizer.ActionMappingPanel;
import org.mevenide.netbeans.project.customizer.BasicsPanel;
import org.mevenide.netbeans.project.customizer.BuildPanel;
import org.mevenide.netbeans.project.customizer.DependenciesPanel;
import org.mevenide.netbeans.project.customizer.DescriptionPanel;
import org.mevenide.netbeans.project.customizer.FilesPanel;
import org.mevenide.netbeans.project.customizer.JavaPanel;
import org.mevenide.netbeans.project.customizer.ListsPanel;
import org.mevenide.netbeans.project.customizer.OrgPanel;
import org.mevenide.netbeans.project.customizer.PluginListPanel;
import org.mevenide.netbeans.project.customizer.ReportsPanel;
import org.mevenide.netbeans.project.customizer.RepositoryPanel;
import org.mevenide.netbeans.project.customizer.TeamPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class MavenCustomizer
extends JPanel
implements ProjectValidateObserver {
    private Component currentCustomizer;
    private GridBagConstraints fillConstraints;
    private MavenProject project;
    private CategoryView catView;
    private List allPanels;
    private JPanel categoryPanel;
    private JCheckBox cbResolve;
    private JPanel customizerPanel;
    private JLabel lblValidateMessage;

    public MavenCustomizer(MavenProject proj) {
        this.initComponents();
        this.project = proj;
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.catView = new CategoryView();
        this.categoryPanel.add((Component)this.catView, this.fillConstraints);
        this.cbResolve.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Node[] nodes = MavenCustomizer.this.catView.getExplorerManager().getSelectedNodes();
                if (nodes.length > 0) {
                    MavenCustomizer.this.changeCustomizer(nodes[0]);
                }
            }
        });
    }

    private void initComponents() {
        this.categoryPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.lblValidateMessage = new JLabel();
        this.cbResolve = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 450));
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryPanel.setBorder(new EtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(150, 4));
        this.categoryPanel.setPreferredSize(new Dimension(220, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.customizerPanel.setLayout(new GridBagLayout());
        this.customizerPanel.setMinimumSize(new Dimension(150, 5));
        this.customizerPanel.setPreferredSize(new Dimension(250, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.75;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.lblValidateMessage.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.lblValidateMessage, gridBagConstraints);
        this.cbResolve.setText("Resolve Values");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.cbResolve, gridBagConstraints);
    }

    private void changeCustomizer(Node node) {
        if (this.currentCustomizer != null) {
            this.customizerPanel.remove(this.currentCustomizer);
        }
        if (node.hasCustomizer()) {
            this.currentCustomizer = node.getCustomizer();
            this.customizerPanel.add(this.currentCustomizer, this.fillConstraints);
            if (this.currentCustomizer instanceof ProjectPanel) {
                ProjectPanel prpanel = (ProjectPanel)((Object)this.currentCustomizer);
                this.lblValidateMessage.setText("");
                prpanel.setValidateObserver(this);
                prpanel.setResolveValues(this.cbResolve.isSelected());
            }
            this.customizerPanel.validate();
            this.customizerPanel.repaint();
        } else {
            this.currentCustomizer = null;
        }
    }

    private Node createRootNode(MavenProject project, ExplorerManager manager) {
        this.allPanels = new ArrayList();
        ConfigurationDescription[] generalChilds = new ConfigurationDescription[]{new ConfigurationDescription("DescCategory", "Description", "org/mevenide/netbeans/project/resources/Bullet", new DescriptionPanel(project), null), new ConfigurationDescription("OrgCategory", "Organization and Site", "org/mevenide/netbeans/project/resources/Bullet", new OrgPanel(project), null), new ConfigurationDescription("RepositoryCategory", "Repository", "org/mevenide/netbeans/project/resources/Bullet", new RepositoryPanel(project), null), new ConfigurationDescription("ListsCategory", "Lists", "org/mevenide/netbeans/project/resources/Bullet", new ListsPanel(project), null), new ConfigurationDescription("TeamCategory", "Team", "org/mevenide/netbeans/project/resources/Bullet", new TeamPanel(project), null), new ConfigurationDescription("ReportsCategory", "Reports", "org/mevenide/netbeans/project/resources/Bullet", new ReportsPanel(project), null)};
        ConfigurationDescription[] buildChilds = new ConfigurationDescription[]{new ConfigurationDescription("JavaCategory", "Java/Jar", "org/mevenide/netbeans/project/resources/Bullet", new JavaPanel(project), null), new ConfigurationDescription("UnitTestsCategory", "Unit Tests", "org/mevenide/netbeans/project/resources/Bullet", MavenCustomizer.createEmptyLabel("WORK IN PROGRESS..."), null)};
        ConfigurationDescription[] descriptions = new ConfigurationDescription[]{new ConfigurationDescription("GeneralCategory", "General", "org/mevenide/netbeans/project/resources/Bullet", new BasicsPanel(project), generalChilds), new ConfigurationDescription("DependencyCategory", "Dependencies", "org/mevenide/netbeans/project/resources/Bullet", new DependenciesPanel(project, false), null), new ConfigurationDescription("BuildCategory", "Build", "org/mevenide/netbeans/project/resources/Bullet", new BuildPanel(project), buildChilds), new ConfigurationDescription("FilesCategory", "Project Files", "org/mevenide/netbeans/project/resources/Bullet", new FilesPanel(false, project), null), new ConfigurationDescription("MappingCategory", "Goal to IDE Action Mappings", "org/mevenide/netbeans/project/resources/Bullet", new ActionMappingPanel(project), null), new ConfigurationDescription("pluginsCategory", "Plugins", "org/mevenide/netbeans/project/resources/Bullet", new PluginListPanel(project, this.allPanels, manager))};
        this.addPanelsToList(this.allPanels, descriptions);
        this.addPanelsToList(this.allPanels, buildChilds);
        this.addPanelsToList(this.allPanels, generalChilds);
        ConfigurationDescription rootDescription = new ConfigurationDescription("InvisibleRoot", "InvisibleRoot", null, null, descriptions);
        return new ConfigurationNode(rootDescription);
    }

    private void addPanelsToList(List list, ConfigurationDescription[] descs) {
        for (int i = 0; i < descs.length; ++i) {
            if (descs[i].customizer == null || !(descs[i].customizer instanceof ProjectPanel)) continue;
            list.add(descs[i].customizer);
        }
    }

    private static JLabel createEmptyLabel(String text) {
        JLabel label;
        if (text == null) {
            label = new JLabel();
        } else {
            label = new JLabel(text);
            label.setHorizontalAlignment(0);
        }
        return label;
    }

    public void resetValidState(boolean valid, String errorMessage) {
        if (valid) {
            this.lblValidateMessage.setText("");
        } else {
            this.lblValidateMessage.setText(errorMessage);
        }
    }

    public List getChanges() {
        ArrayList toReturn = new ArrayList();
        Iterator it = this.allPanels.iterator();
        while (it.hasNext()) {
            ProjectPanel panel = (ProjectPanel)it.next();
            toReturn.addAll(panel.getChanges());
        }
        return toReturn;
    }

    private static class ConfigurationChildren
    extends Children.Keys {
        private Collection descriptions;

        public ConfigurationChildren(ConfigurationDescription[] descriptions) {
            this.descriptions = Arrays.asList(descriptions);
        }

        public void addNotify() {
            this.setKeys(this.descriptions);
        }

        public void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new ConfigurationNode((ConfigurationDescription)key)};
        }
    }

    private static class ConfigurationNode
    extends AbstractNode {
        private Component customizer;

        public ConfigurationNode(ConfigurationDescription description) {
            super((Children)(description.children == null ? (description.childs2 == null ? Children.LEAF : description.childs2) : new ConfigurationChildren(description.children)));
            this.setName(description.name);
            this.setDisplayName(description.displayName);
            if (description.iconBase != null) {
                this.setIconBase(description.iconBase);
            }
            this.customizer = description.customizer;
        }

        public boolean hasCustomizer() {
            return this.customizer != null;
        }

        public Component getCustomizer() {
            return this.customizer;
        }
    }

    private static class ConfigurationDescription {
        private String name;
        private String displayName;
        private String iconBase;
        private Component customizer;
        private ConfigurationDescription[] children;
        private Children childs2;

        ConfigurationDescription(String name, String displayName, String iconBase, Component customizer, ConfigurationDescription[] children) {
            this.name = name;
            this.displayName = displayName;
            this.iconBase = iconBase;
            this.customizer = customizer;
            this.children = children;
        }

        ConfigurationDescription(String name, String displayName, String iconBase, PluginListPanel customizer) {
            this.name = name;
            this.displayName = displayName;
            this.iconBase = iconBase;
            this.customizer = customizer;
            this.childs2 = customizer.getNodeChildren();
        }
    }

    private class CategoryView
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();
        private BeanTreeView btv;

        CategoryView() {
            this.setLayout(new BorderLayout());
            Dimension size = new Dimension(190, 4);
            this.btv = new BeanTreeView();
            this.btv.setSelectionMode(1);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(size);
            this.btv.setPreferredSize(size);
            this.btv.setMaximumSize(size);
            this.add((Component)this.btv, "Center");
            this.manager.setRootContext(MavenCustomizer.this.createRootNode(MavenCustomizer.this.project, this.manager));
            this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerChangeListener());
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public void addNotify() {
            super.addNotify();
            this.doExpand();
            this.selectFirstNode();
        }

        private void doExpand() {
            this.btv.expandNode(this.manager.getRootContext());
            Node root = this.manager.getRootContext();
            Node[] children = root.getChildren().getNodes();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].getName().equals("pluginsCategory")) continue;
                this.btv.expandNode(children[i]);
            }
        }

        private void selectFirstNode() {
            Node[] nodes;
            Children ch = this.manager.getRootContext().getChildren();
            if (ch != null && (nodes = ch.getNodes()) != null && nodes.length > 0) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodes[0]});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    Node[] nodes = CategoryView.this.manager.getSelectedNodes();
                    if (nodes == null || nodes.length <= 0) {
                        return;
                    }
                    Node node = nodes[0];
                    MavenCustomizer.this.changeCustomizer(node);
                    return;
                }
            }
        }
    }
}

