/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.context.IQueryContext;
import org.mevenide.netbeans.api.customizer.CustomPluginPanelProvider;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.customizer.changes.MavenChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.customizer.ui.OriginChangeCellEditor;
import org.mevenide.netbeans.project.customizer.ui.PropertyTableModel;
import org.mevenide.netbeans.project.customizer.ui.TableRowPropertyChange;
import org.mevenide.plugins.IPluginInfo;
import org.openide.util.Lookup;

public class PluginPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)PluginPanel.class);
    private ProjectValidateObserver valObserver;
    private MavenProject project;
    private PropertyTableModel mod;
    private HashMap changes;
    private Set propKeys;
    private JLabel lblDescription;
    private JScrollPane spProperties;
    private JTable tblProperties;

    public PluginPanel(MavenProject proj, Set keys) {
        this.project = proj;
        this.propKeys = keys;
        this.changes = new HashMap();
        this.initComponents();
        this.valObserver = null;
        this.populateChangeInstances();
    }

    public PluginPanel(MavenProject proj, Set keys, IPluginInfo info) {
        this(proj, keys);
        this.lblDescription.setText("<html>These are known properties for plugin <b>" + info.getName() + "</b> in version <b>" + info.getVersion() + "</b></html>");
    }

    private void initComponents() {
        this.spProperties = new JScrollPane();
        this.tblProperties = new JTable();
        this.lblDescription = new JLabel();
        this.setLayout(new GridBagLayout());
        this.spProperties.setViewportView(this.tblProperties);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.spProperties, gridBagConstraints);
        this.lblDescription.setText("This is a list of all properties overriden in the project's and user's property files.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.lblDescription, gridBagConstraints);
    }

    private void populateChangeInstances() {
        Iterator it = this.propKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.createChangeInstance(key);
        }
        this.mod = new PropertyTableModel(this.project.getPropertyResolver(), this.changes.values());
        this.tblProperties.setModel(this.mod);
        TableColumn col = this.tblProperties.getTableHeader().getColumnModel().getColumn(2);
        col.setMaxWidth(40);
        col.setMinWidth(20);
        col.setPreferredWidth(30);
        col.setCellRenderer(this.mod);
        col.setCellEditor(new OriginChangeCellEditor(LocationComboFactory.createPropertiesChange(this.project)));
        col = this.tblProperties.getTableHeader().getColumnModel().getColumn(1);
        col.setCellRenderer(this.mod);
        col = this.tblProperties.getTableHeader().getColumnModel().getColumn(0);
        col.setCellRenderer(this.mod);
        this.tblProperties.setSurrendersFocusOnKeystroke(true);
    }

    private void createChangeInstance(String key) {
        String value = this.project.getPropertyResolver().getValue(key);
        int location = this.project.getPropertyLocator().getPropertyLocation(key);
        if (value == null) {
            value = "";
            location = -1;
        }
        OriginChange chng = LocationComboFactory.createPropertiesChange(this.project);
        String def = this.project.getPropertyLocator().getValueAtLocation(key, -2);
        def = def == null ? "" : def;
        this.changes.put(key, new TableRowPropertyChange(key, value, location, chng, def));
    }

    public List getChanges() {
        ArrayList<MavenChange> toReturn = new ArrayList<MavenChange>();
        Iterator it = this.changes.values().iterator();
        while (it.hasNext()) {
            MavenChange change = (MavenChange)it.next();
            if (!change.hasChanged()) continue;
            toReturn.add(change);
        }
        return toReturn;
    }

    public void setResolveValues(boolean resolve) {
        this.mod.setResolve(resolve);
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    private void doValidate() {
        logger.debug((Object)"Listener called");
        ProjectValidateObserver obs = this.valObserver;
        if (obs != null) {
            obs.resetValidState(this.isInValidState(), this.getValidityMessage());
        }
    }

    private int doValidateCheck() {
        return 0;
    }

    public boolean isInValidState() {
        return this.doValidateCheck() == 0;
    }

    public String getValidityMessage() {
        int retCode = this.doValidateCheck();
        String message = "";
        return message;
    }

    public static Component createUsedPanel(MavenProject proj) {
        IQueryContext context = proj.getContext();
        HashSet used = new HashSet();
        used.addAll(context.getUserPropertyKeys());
        int depth = context.getPOMContext().getProjectDepth();
        for (int i = 1; i <= depth; ++i) {
            used.addAll(context.getPropertyKeysAt(i * 10 + 1));
            used.addAll(context.getPropertyKeysAt(i * 10 + 0));
        }
        return new PluginPanel(proj, used);
    }

    public static Component createPluginPanel(MavenProject proj, IPluginInfo info) {
        Lookup.Result res = Lookup.getDefault().lookup(new Lookup.Template(CustomPluginPanelProvider.class));
        Iterator it = res.allInstances().iterator();
        while (it.hasNext()) {
            CustomPluginPanelProvider prov = (CustomPluginPanelProvider)it.next();
            JComponent panel = prov.createPanel(proj, info);
            if (panel == null) continue;
            return panel;
        }
        HashSet used = new HashSet();
        used.addAll(info.getPropertyKeys());
        return new PluginPanel(proj, used, info);
    }
}

