/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.netbeans.api.customizer.LocationComboFactory;
import org.mevenide.netbeans.api.customizer.OriginChange;
import org.mevenide.netbeans.api.customizer.ProjectPanel;
import org.mevenide.netbeans.api.customizer.ProjectValidateObserver;
import org.mevenide.netbeans.api.customizer.changes.ListModelPOMChange;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.reports.IReportsFinder;
import org.mevenide.reports.JDomReportsFinder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ReportsPanel
extends JPanel
implements ProjectPanel {
    private static Log logger = LogFactory.getLog((Class)ReportsPanel.class);
    private ProjectValidateObserver valObserver;
    private Listener listener;
    private MavenProject project;
    private OriginChange ocReports;
    private DefaultListModel model;
    private ListModelPOMChange change;
    private IReportsFinder finder;
    private boolean initialized;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnReports;
    private JLabel lblLists;
    private JList lstLists;
    private JScrollPane spLists;

    public ReportsPanel(MavenProject proj) {
        this.project = proj;
        this.initComponents();
        this.valObserver = null;
        this.setName("Reports");
        this.lstLists.setSelectionMode(2);
        this.initialized = false;
    }

    private void initComponents() {
        this.lblLists = new JLabel();
        this.ocReports = LocationComboFactory.createPOMChange(this.project, true);
        this.btnReports = (JButton)this.ocReports.getComponent();
        this.spLists = new JScrollPane();
        this.lstLists = new JList();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblLists.setLabelFor(this.lstLists);
        this.lblLists.setText("Reports:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblLists, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.btnReports, gridBagConstraints);
        this.spLists.setPreferredSize(new Dimension(300, 131));
        this.spLists.setViewportView(this.lstLists);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.spLists, gridBagConstraints);
        this.btnAdd.setText("Add");
        this.btnAdd.setActionCommand("btnAdd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setText("Remove");
        this.btnRemove.setActionCommand("btnRemove");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.btnRemove, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            this.populateChangeInstances();
        }
        this.listener = new Listener();
        this.btnAdd.addActionListener(this.listener);
        this.btnRemove.addActionListener(this.listener);
        this.lstLists.addListSelectionListener(this.listener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btnAdd.removeActionListener(this.listener);
        this.btnRemove.removeActionListener(this.listener);
        this.lstLists.removeListSelectionListener(this.listener);
    }

    private void populateChangeInstances() {
        String key = "pom.reports";
        int location = this.project.getProjectWalker().getLocation(key);
        ArrayList oldValues = new ArrayList();
        List orig = this.project.getOriginalMavenProject().getReports();
        if (orig != null) {
            oldValues.addAll(orig);
        }
        this.model = new DefaultListModel();
        this.lstLists.setModel(this.model);
        this.change = new ListModelPOMChange(key, oldValues, location, this.model, this.ocReports);
    }

    public void setResolveValues(boolean resolve) {
        if (resolve) {
            List list = this.change.getChangedContent().getValueList("reports", "report");
            if (list != null) {
                ArrayList<String> resolved = new ArrayList<String>();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    String report = (String)it.next();
                    resolved.add(this.project.getPropertyResolver().resolveString(report));
                }
                this.change.setResolvedValues(resolved);
            }
        } else {
            this.change.resetToNonResolvedValue();
        }
        this.btnRemove.setEnabled(!resolve);
        this.btnAdd.setEnabled(!resolve);
    }

    public List getChanges() {
        ArrayList<ListModelPOMChange> toReturn = new ArrayList<ListModelPOMChange>();
        if (this.initialized && this.change.hasChanged()) {
            toReturn.add(this.change);
        }
        return toReturn;
    }

    public void setValidateObserver(ProjectValidateObserver observer) {
        this.valObserver = observer;
    }

    public boolean isInValidState() {
        return true;
    }

    public String getValidityMessage() {
        String message = "";
        return message;
    }

    private IReportsFinder getReportsFinder() {
        if (this.finder == null) {
            this.finder = new JDomReportsFinder(this.project.getLocFinder());
        }
        return this.finder;
    }

    private JPanel createAddPanel(JList list) {
        JPanel panel = new JPanel();
        JLabel jLabel1 = new JLabel();
        panel.setLayout(new GridBagLayout());
        jLabel1.setText("Available Reports:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        panel.add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        list.setVisibleRowCount(12);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(list);
        panel.add((Component)pane, gridBagConstraints);
        return panel;
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent e) {
            if ("btnRemove".equals(e.getActionCommand())) {
                Object[] values = ReportsPanel.this.lstLists.getSelectedValues();
                for (int i = 0; i < values.length; ++i) {
                    ReportsPanel.this.model.removeElement(values[i]);
                }
            }
            if ("btnAdd".equals(e.getActionCommand())) {
                try {
                    String[] reports = ReportsPanel.this.getReportsFinder().findReports();
                    TreeSet<String> additional = new TreeSet<String>(Arrays.asList(reports));
                    additional.removeAll(ReportsPanel.this.change.getChangedContent().getValueList("reports", "report"));
                    JList<Object> list = new JList<Object>(additional.toArray());
                    Object[] options = new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION};
                    NotifyDescriptor dd = new NotifyDescriptor((Object)ReportsPanel.this.createAddPanel(list), "Add Reports", 2, -1, options, options[0]);
                    Object val = DialogDisplayer.getDefault().notify(dd);
                    if (val == options[0]) {
                        Object[] values = list.getSelectedValues();
                        for (int i = 0; i < values.length; ++i) {
                            ReportsPanel.this.model.addElement(values[i]);
                        }
                    }
                }
                catch (Exception exc) {
                    logger.error((Object)"exception while retrieving reports", (Throwable)exc);
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }
}

