/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.exec;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mevenide.goals.grabber.IGoalsGrabber;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.MavenSettings;
import org.mevenide.netbeans.project.exec.CustomGoalsPanel;
import org.mevenide.netbeans.project.goals.GoalNameCookie;
import org.mevenide.netbeans.project.goals.GoalsGrabberProvider;
import org.mevenide.netbeans.project.goals.GoalsRootNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RunGoalsPanel
extends JPanel {
    private static final Log logger = LogFactory.getLog((Class)RunGoalsPanel.class);
    public static final String ACTION_GOALS_CHANGED = "GoalsChanged";
    private GoalsGrabberProvider provider;
    private MavenProject project;
    private List actionListeners = new ArrayList();
    private static String lastGoal = null;
    private JCheckBox cbDebugMessages;
    private JCheckBox cbExceptions;
    private JCheckBox cbNoBanner;
    private JCheckBox cbOffline;
    private JCheckBox cbReduceOutput;
    private ExplorerPanel epGoals;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private JLabel lblDescription;
    private JLabel lblEnter;
    private JLabel lblGoals;
    private JLabel lblMavenHome;
    private JLabel lblMavenLocalHome;
    private JPanel pnlBrowser;
    private JPanel pnlOptions;
    private JTextArea taDescription;
    private BeanTreeView tvGoals;
    private JTextField txtEnter;
    private JTextField txtMavenHome;
    private JTextField txtMavenLocalHome;
    static /* synthetic */ Class class$org$mevenide$netbeans$project$goals$GoalNameCookie;

    public RunGoalsPanel(MavenProject proj, GoalsGrabberProvider goalsProvider) {
        this.initComponents();
        this.provider = goalsProvider;
        this.project = proj;
        this.tvGoals.setSelectionMode(4);
        this.tvGoals.setRootVisible(false);
        if (lastGoal != null) {
            this.txtEnter.setText(lastGoal);
            this.txtEnter.setCaretPosition(lastGoal.length());
            this.txtEnter.setSelectionStart(0);
            this.txtEnter.setSelectionEnd(lastGoal.length());
        } else {
            this.txtEnter.setText("");
        }
        this.txtEnter.getDocument().addDocumentListener(new DocListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener listener) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener listener) {
        List list = this.actionListeners;
        synchronized (list) {
            this.actionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionEvent(ActionEvent event) {
        if (this.actionListeners.size() > 0) {
            ArrayList listeners = new ArrayList();
            List list = this.actionListeners;
            synchronized (list) {
                listeners.addAll(this.actionListeners);
            }
            if (listeners.size() > 0) {
                Iterator it = listeners.iterator();
                while (it.hasNext()) {
                    ActionListener list2 = (ActionListener)it.next();
                    list2.actionPerformed(event);
                }
            }
        }
    }

    public String getGoalsToExecute() {
        lastGoal = this.txtEnter.getText();
        return this.txtEnter.getText();
    }

    public void setGoalsToExecute(String goals) {
        this.txtEnter.setText(goals);
        this.txtEnter.setSelectionStart(0);
        this.txtEnter.setSelectionEnd(goals.length());
    }

    public boolean isOffline() {
        return this.cbOffline.isSelected();
    }

    public boolean isDebug() {
        return this.cbDebugMessages.isSelected();
    }

    public boolean isExceptions() {
        return this.cbExceptions.isSelected();
    }

    public boolean isNoBanner() {
        return this.cbNoBanner.isSelected();
    }

    public boolean isNonverbose() {
        return this.cbReduceOutput.isSelected();
    }

    public String getMavenHome() {
        return this.txtMavenHome.getText();
    }

    public String getMavenLocalHome() {
        return this.txtMavenLocalHome.getText();
    }

    private void initComponents() {
        this.lblEnter = new JLabel();
        this.txtEnter = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlBrowser = new JPanel();
        this.lblGoals = new JLabel();
        this.epGoals = new ExplorerPanel();
        this.tvGoals = new BeanTreeView();
        this.lblDescription = new JLabel();
        this.taDescription = new JTextArea();
        this.pnlOptions = new JPanel();
        this.cbOffline = new JCheckBox();
        this.cbNoBanner = new JCheckBox();
        this.cbReduceOutput = new JCheckBox();
        this.cbDebugMessages = new JCheckBox();
        this.cbExceptions = new JCheckBox();
        this.lblMavenHome = new JLabel();
        this.txtMavenHome = new JTextField();
        this.lblMavenLocalHome = new JLabel();
        this.txtMavenLocalHome = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.lblEnter.setLabelFor(this.txtEnter);
        this.lblEnter.setText("Enter goal(s) :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblEnter, gridBagConstraints);
        this.txtEnter.setMinimumSize(new Dimension(60, 28));
        this.txtEnter.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.txtEnter, gridBagConstraints);
        this.jTabbedPane1.setTabLayoutPolicy(1);
        this.jTabbedPane1.setTabPlacement(3);
        this.pnlBrowser.setLayout(new GridBagLayout());
        this.lblGoals.setLabelFor((Component)this.epGoals);
        this.lblGoals.setText("Available Goals:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 5, 0, 0);
        this.pnlBrowser.add((Component)this.lblGoals, gridBagConstraints);
        this.epGoals.setMinimumSize(new Dimension(150, 100));
        this.tvGoals.setPreferredSize(new Dimension(400, 323));
        this.epGoals.add((Component)this.tvGoals, (Object)"Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 5, 0, 6);
        this.pnlBrowser.add((Component)this.epGoals, gridBagConstraints);
        this.lblDescription.setText("Description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 5, 0, 0);
        this.pnlBrowser.add((Component)this.lblDescription, gridBagConstraints);
        this.taDescription.setEditable(false);
        this.taDescription.setLineWrap(true);
        this.taDescription.setRows(2);
        this.taDescription.setTabSize(4);
        this.taDescription.setWrapStyleWord(true);
        this.taDescription.setMinimumSize(new Dimension(50, 24));
        this.taDescription.setPreferredSize(new Dimension(100, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.pnlBrowser.add((Component)this.taDescription, gridBagConstraints);
        this.jTabbedPane1.addTab("Browser", this.pnlBrowser);
        this.pnlOptions.setLayout(new GridBagLayout());
        this.cbOffline.setText("Build Offline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.pnlOptions.add((Component)this.cbOffline, gridBagConstraints);
        this.cbNoBanner.setText("Hide Maven Banner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.pnlOptions.add((Component)this.cbNoBanner, gridBagConstraints);
        this.cbReduceOutput.setText("Reduce execution output");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.pnlOptions.add((Component)this.cbReduceOutput, gridBagConstraints);
        this.cbDebugMessages.setText("Show debug  messages");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.pnlOptions.add((Component)this.cbDebugMessages, gridBagConstraints);
        this.cbExceptions.setText("Print exception traces");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.pnlOptions.add((Component)this.cbExceptions, gridBagConstraints);
        this.lblMavenHome.setText("Maven Home :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.pnlOptions.add((Component)this.lblMavenHome, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.pnlOptions.add((Component)this.txtMavenHome, gridBagConstraints);
        this.lblMavenLocalHome.setText("Maven Local Home :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.pnlOptions.add((Component)this.lblMavenLocalHome, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.pnlOptions.add((Component)this.txtMavenLocalHome, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 6, 0);
        this.pnlOptions.add((Component)this.jSeparator1, gridBagConstraints);
        this.jTabbedPane1.addTab("Options", this.pnlOptions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        this.epGoals.getExplorerManager().setRootContext(this.createLoadingNode());
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    final IGoalsGrabber grabber = RunGoalsPanel.this.provider.getGoalsGrabber();
                    if (grabber == null) {
                        logger.error((Object)"No grabber");
                        throw new Exception("no grabber");
                    }
                    grabber.refresh();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RunGoalsPanel.this.epGoals.getExplorerManager().setRootContext((Node)new GoalsRootNode(grabber));
                        }
                    });
                }
                catch (Exception exc) {
                    ErrorManager.getDefault().notify((Throwable)exc);
                    logger.error((Object)"Error while retrieving goals", (Throwable)exc);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RunGoalsPanel.this.epGoals.getExplorerManager().setRootContext(RunGoalsPanel.this.createNoGoalsNode());
                        }
                    });
                }
            }
        });
        this.epGoals.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new PropListener());
        this.cbOffline.setSelected(MavenSettings.getDefault().isOffline());
        this.cbDebugMessages.setSelected(MavenSettings.getDefault().isDebug());
        this.cbExceptions.setSelected(MavenSettings.getDefault().isExceptions());
        this.cbNoBanner.setSelected(MavenSettings.getDefault().isNoBanner());
        this.cbReduceOutput.setSelected(MavenSettings.getDefault().isNonverbose());
        this.txtMavenHome.setText(this.project.getLocFinder().getMavenHome());
        this.txtMavenLocalHome.setText(this.project.getLocFinder().getMavenLocalHome());
    }

    private Node createLoadingNode() {
        Children.Array childs = new Children.Array();
        AbstractNode loading = new AbstractNode(Children.LEAF);
        loading.setName("Loading");
        loading.setDisplayName(NbBundle.getBundle((Class)CustomGoalsPanel.class).getString("Loading"));
        childs.add(new Node[]{loading});
        return new AbstractNode((Children)childs);
    }

    private Node createNoGoalsNode() {
        Children.Array childs = new Children.Array();
        AbstractNode node = new AbstractNode(Children.LEAF);
        node.setName("NoGoals");
        node.setDisplayName(NbBundle.getBundle((Class)CustomGoalsPanel.class).getString("NoGoals"));
        childs.add(new Node[]{node});
        return new AbstractNode((Children)childs);
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            this.generateActionEvent();
        }

        public void insertUpdate(DocumentEvent e) {
            this.generateActionEvent();
        }

        public void removeUpdate(DocumentEvent e) {
            this.generateActionEvent();
        }

        private void generateActionEvent() {
            ActionEvent newEvent = new ActionEvent(RunGoalsPanel.this, 1001, RunGoalsPanel.ACTION_GOALS_CHANGED);
            RunGoalsPanel.this.fireActionEvent(newEvent);
        }
    }

    private class PropListener
    implements PropertyChangeListener {
        private PropListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] nds = RunGoalsPanel.this.epGoals.getExplorerManager().getSelectedNodes();
                StringBuffer goals = new StringBuffer();
                for (int i = 0; i < nds.length; ++i) {
                    GoalNameCookie cook = (GoalNameCookie)nds[i].getCookie(class$org$mevenide$netbeans$project$goals$GoalNameCookie == null ? RunGoalsPanel.class$("org.mevenide.netbeans.project.goals.GoalNameCookie") : class$org$mevenide$netbeans$project$goals$GoalNameCookie);
                    if (cook == null) continue;
                    goals.append(cook.getGoalName());
                    goals.append(" ");
                    if (i != nds.length - 1) continue;
                    RunGoalsPanel.this.taDescription.setText(nds[i].getShortDescription());
                }
                if (nds.length == 0) {
                    RunGoalsPanel.this.taDescription.setText("");
                }
                int currPos = RunGoalsPanel.this.txtEnter.getCaretPosition();
                int length = goals.length();
                String currSelected = RunGoalsPanel.this.txtEnter.getSelectedText();
                int selStart = currSelected == null ? currPos : RunGoalsPanel.this.txtEnter.getSelectionStart();
                int selEnd = currSelected == null ? currPos : RunGoalsPanel.this.txtEnter.getSelectionEnd();
                logger.debug((Object)("selstart=" + selStart + "  selEnd=" + selEnd));
                String text = RunGoalsPanel.this.txtEnter.getText();
                if (selStart > 0) {
                    goals.insert(0, text.substring(0, selStart));
                }
                if (selEnd < text.length()) {
                    goals.append(text.substring(selEnd + 1));
                }
                RunGoalsPanel.this.txtEnter.setText(goals.toString());
                RunGoalsPanel.this.txtEnter.setCaretPosition(selStart + length);
                RunGoalsPanel.this.txtEnter.setSelectionStart(selStart);
                RunGoalsPanel.this.txtEnter.setSelectionEnd(selStart + length);
            }
        }
    }
}

