/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.nodes;

import java.awt.Image;
import java.util.Collections;
import javax.swing.Action;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.netbeans.project.ActionProviderImpl;
import org.mevenide.netbeans.project.nodes.VisibilityQueryDataFilter;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class DocsRootNode
extends AbstractNode {
    private SourceGroup group;
    private MavenProject project;

    DocsRootNode(SourceGroup grp, MavenProject proj) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{DataFolder.findFolder((FileObject)grp.getRootFolder()), proj}));
        this.project = proj;
        this.setName("XDocumentation");
        this.setDisplayName("Documentation");
        this.setIconBase("org/openide/loaders/defaultFolder");
        this.group = grp;
        DataFolder dobj = DataFolder.findFolder((FileObject)this.group.getRootFolder());
        if (dobj != null) {
            final Children childs = dobj.createNodeChildren((DataFilter)new VisibilityQueryDataFilter());
            Children.MUTEX.postWriteRequest(new Runnable(){

                public void run() {
                    DocsRootNode.this.setChildren(childs);
                }
            });
        }
    }

    public Image getOpenedIcon(int param) {
        Image img = super.getOpenedIcon(param);
        FileObject fo = this.group.getRootFolder();
        try {
            img = fo.getFileSystem().getStatus().annotateIcon(img, param, Collections.singleton(fo));
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return img;
    }

    public Image getIcon(int param) {
        Image img = super.getOpenedIcon(param);
        FileObject fo = this.group.getRootFolder();
        try {
            img = fo.getFileSystem().getStatus().annotateIcon(img, param, Collections.singleton(fo));
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return img;
    }

    public Action[] getActions(boolean param) {
        Action[] toReturn = new Action[10];
        ActionProviderImpl provider = (ActionProviderImpl)this.project.getLookup().lookup(ActionProviderImpl.class);
        toReturn[0] = CommonProjectActions.newFileAction();
        toReturn[1] = null;
        toReturn[2] = provider.createCustomMavenAction("Generate Site", "site:generate");
        String method = this.project.getPropertyResolver().getResolvedValue("maven.site.deploy.method");
        String deployName = "Deploy site using ";
        deployName = method != null && method.equalsIgnoreCase("fs") ? deployName + "filesystem" : deployName + "ssh";
        toReturn[3] = provider.createCustomMavenAction(deployName, "site:deploy");
        toReturn[4] = null;
        toReturn[5] = SystemAction.get((Class)FindAction.class);
        toReturn[6] = null;
        toReturn[7] = SystemAction.get((Class)FileSystemAction.class);
        toReturn[8] = null;
        toReturn[9] = SystemAction.get((Class)ToolsAction.class);
        return toReturn;
    }
}

