/*
 * Decompiled with CFR 0.152.
 */
package org.mevenide.netbeans.project.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.project.Project;
import org.mevenide.netbeans.api.project.MavenProject;
import org.mevenide.project.dependency.DependencyResolverFactory;
import org.mevenide.project.dependency.IDependencyResolver;
import org.mevenide.properties.IPropertyResolver;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public class MavenForBinaryQueryImpl
implements SourceForBinaryQueryImplementation,
JavadocForBinaryQueryImplementation {
    private static final Log logger = LogFactory.getLog((Class)MavenForBinaryQueryImpl.class);
    private MavenProject project;
    private BinResult srcResult;
    private BinResult jarResult;
    private BinResult testResult;

    public MavenForBinaryQueryImpl(MavenProject proj) {
        this.project = proj;
        this.project.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (MavenForBinaryQueryImpl.this.srcResult != null) {
                    MavenForBinaryQueryImpl.this.srcResult.fireChanged();
                }
                if (MavenForBinaryQueryImpl.this.jarResult != null) {
                    MavenForBinaryQueryImpl.this.jarResult.fireChanged();
                }
                if (MavenForBinaryQueryImpl.this.testResult != null) {
                    MavenForBinaryQueryImpl.this.testResult.fireChanged();
                }
            }
        });
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL url) {
        if (url.getProtocol().equals("jar") && this.checkURL(url) != -1) {
            if (this.jarResult == null) {
                logger.debug((Object)("MavenSourceForBinaryQueryImpl project=" + this.project.getDisplayName() + "url=" + url));
                this.jarResult = new BinResult(url);
            }
            return this.jarResult;
        }
        if (url.getProtocol().equals("file")) {
            int result = this.checkURL(url);
            if (result == 1) {
                if (this.testResult == null) {
                    this.testResult = new BinResult(url);
                }
                return this.testResult;
            }
            if (result == 0) {
                if (this.srcResult == null) {
                    this.srcResult = new BinResult(url);
                }
                return this.srcResult;
            }
        }
        return null;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL url) {
        if (this.checkURL(url) != -1) {
            logger.debug((Object)("JavadocForBinaryQueryImplementation project=" + this.project.getDisplayName() + "url=" + url));
            return new DocResult(url);
        }
        return null;
    }

    private int checkURL(URL url) {
        URL binRoot;
        FileObject fo;
        logger.debug((Object)("checkurl=" + url));
        if ("file".equals(url.getProtocol())) {
            try {
                URL testsrcUrl;
                URL srcUrl = this.project.getBuildClassesDir().toURL();
                if (url.equals(srcUrl)) {
                    return 0;
                }
                URI uri = this.project.getTestBuildClassesDir();
                if (uri != null && url.equals(testsrcUrl = uri.toURL())) {
                    return 1;
                }
            }
            catch (MalformedURLException exc) {
                logger.warn((Object)"exception maplformed url.", (Throwable)exc);
            }
            return -1;
        }
        if ("jar".equals(url.getProtocol()) && (fo = URLMapper.findFileObject((URL)(binRoot = FileUtil.getArchiveFile((URL)url)))) != null) {
            logger.debug((Object)("checkurl fo=" + fo));
            Project mavproj = this.project.getOriginalMavenProject();
            File file = FileUtil.toFile((FileObject)fo);
            try {
                IDependencyResolver depRes = DependencyResolverFactory.getFactory().newInstance(file.getAbsolutePath());
                IPropertyResolver res = this.project.getPropertyResolver();
                boolean found = this.doCompare(depRes.guessArtifactId(), res.resolveString(mavproj.getArtifactId())) && this.doCompare(depRes.guessGroupId(), res.resolveString(mavproj.getGroupId())) && ("SNAPSHOT".equals(depRes.guessVersion()) || this.doCompare(depRes.guessVersion(), res.resolveString(mavproj.getCurrentVersion())));
                return found ? 0 : -1;
            }
            catch (Exception exc) {
                logger.error((Object)"exception", (Throwable)exc);
                return -1;
            }
        }
        return -1;
    }

    private FileObject[] getSrcRoot() {
        Collection adds;
        logger.debug((Object)"getsrcRoot");
        ArrayList<FileObject> toReturn = new ArrayList<FileObject>();
        ArrayList<URI> uris = new ArrayList<URI>();
        URI uri = this.project.getGeneratedSourcesDir();
        if (uri != null) {
            uris.add(uri);
        }
        if ((uri = this.project.getSrcDirectory()) != null) {
            uris.add(uri);
        }
        if ((adds = this.project.getAdditionalGeneratedSourceDirs()) != null) {
            uris.addAll(adds);
        }
        Iterator it = uris.iterator();
        while (it.hasNext()) {
            uri = (URI)it.next();
            try {
                FileObject fo = URLMapper.findFileObject((URL)uri.toURL());
                if (fo == null) continue;
                toReturn.add(fo);
            }
            catch (MalformedURLException exc) {
                logger.warn((Object)("malforrmed uri=" + uri));
            }
        }
        FileObject[] fos = new FileObject[toReturn.size()];
        fos = toReturn.toArray(fos);
        return fos;
    }

    private FileObject[] getTestSrcRoot() {
        logger.debug((Object)"gettestsrcRoot");
        URI uri = this.project.getTestSrcDirectory();
        if (uri != null) {
            try {
                logger.debug((Object)("gettestsrcRoot uri=" + uri));
                FileObject foRoot = URLMapper.findFileObject((URL)uri.toURL());
                if (foRoot != null) {
                    logger.debug((Object)("returning fo=" + foRoot));
                    return new FileObject[]{foRoot};
                }
            }
            catch (MalformedURLException exc) {
                logger.warn((Object)("malforrmed uri=" + uri));
            }
        }
        return new FileObject[0];
    }

    private URL[] getJavadocRoot() {
        logger.debug((Object)"getjavadocRoot");
        String destDir = this.project.getPropertyResolver().getResolvedValue("maven.javadoc.destdir");
        if (destDir != null) {
            File fil = new File(destDir);
            fil = FileUtil.normalizeFile((File)fil);
            try {
                return new URL[]{fil.toURI().toURL()};
            }
            catch (MalformedURLException exc) {
                logger.warn((Object)("malforrmed file uri=" + fil.toURI()));
            }
        } else {
            logger.error((Object)"Cannot resolve maven.javadoc.destdir. How come?");
        }
        return new URL[0];
    }

    private boolean doCompare(String one, String two) {
        if (one == null || two == null) {
            return false;
        }
        return one.trim().equals(two.trim());
    }

    private class DocResult
    implements JavadocForBinaryQuery.Result {
        private URL url;
        private URL[] results;
        private List listeners;

        public DocResult(URL urlParam) {
            this.url = urlParam;
            this.listeners = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList lists = new ArrayList();
            List list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            Iterator it = lists.iterator();
            while (it.hasNext()) {
                ChangeListener listen = (ChangeListener)it.next();
                listen.stateChanged(new ChangeEvent(this));
            }
        }

        public URL[] getRoots() {
            this.results = MavenForBinaryQueryImpl.this.checkURL(this.url) != -1 ? MavenForBinaryQueryImpl.this.getJavadocRoot() : new URL[0];
            return this.results;
        }
    }

    private class BinResult
    implements SourceForBinaryQuery.Result {
        private URL url;
        private List listeners;
        private FileObject[] results;

        public BinResult(URL urlParam) {
            this.url = urlParam;
            this.listeners = new ArrayList();
        }

        public FileObject[] getRoots() {
            int xxx = MavenForBinaryQueryImpl.this.checkURL(this.url);
            this.results = xxx == 0 ? MavenForBinaryQueryImpl.this.getSrcRoot() : (xxx == 1 ? MavenForBinaryQueryImpl.this.getTestSrcRoot() : new FileObject[0]);
            return this.results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList lists = new ArrayList();
            List list = this.listeners;
            synchronized (list) {
                lists.addAll(this.listeners);
            }
            Iterator it = lists.iterator();
            while (it.hasNext()) {
                ChangeListener listen = (ChangeListener)it.next();
                listen.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

