/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.decrypting;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;

final class SignatureValidatingInputStream
extends FilterInputStream {
    private final DecryptionState state;
    private final SignatureValidationStrategy signatureValidationStrategy;

    SignatureValidatingInputStream(InputStream inputStream, DecryptionState state, SignatureValidationStrategy signatureValidationStrategy) {
        super(inputStream);
        Objects.requireNonNull(state, "state must not be null");
        Objects.requireNonNull(signatureValidationStrategy, "signatureValidationStrategy must not be null");
        this.state = state;
        this.signatureValidationStrategy = signatureValidationStrategy;
    }

    @Override
    public int read() throws IOException {
        boolean endOfStream;
        int data = super.read();
        boolean bl = endOfStream = data == -1;
        if (endOfStream) {
            this.validateSignature();
        } else {
            this.state.updateOnePassSignatures((byte)data);
        }
        return data;
    }

    @Override
    public int read(@Nonnull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        boolean endOfStream;
        int read = super.read(b, off, len);
        boolean bl = endOfStream = read == -1;
        if (endOfStream) {
            this.validateSignature();
        } else {
            this.state.updateOnePassSignatures(b, off, read);
        }
        return read;
    }

    private void validateSignature() throws IOException {
        try {
            this.signatureValidationStrategy.validateSignatures(this.state.getSignatureFactory(), this.state.getOnePassSignatures());
        }
        catch (SignatureException | PGPException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Skipping not supported");
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    static final class DecryptionState {
        private final Map<Long, PGPOnePassSignature> onePassSignatures = new HashMap<Long, PGPOnePassSignature>();
        private PGPObjectFactory signatureFactory;

        DecryptionState() {
        }

        PGPObjectFactory getSignatureFactory() {
            return this.signatureFactory;
        }

        void setSignatureFactory(PGPObjectFactory signatureFactory) {
            this.signatureFactory = signatureFactory;
        }

        void updateOnePassSignatures(byte data) {
            for (PGPOnePassSignature sig : this.onePassSignatures.values()) {
                sig.update(data);
            }
        }

        void updateOnePassSignatures(byte[] b, int off, int len) {
            for (PGPOnePassSignature sig : this.onePassSignatures.values()) {
                sig.update(b, off, len);
            }
        }

        Map<Long, PGPOnePassSignature> getOnePassSignatures() {
            return this.onePassSignatures;
        }

        void addSignature(PGPOnePassSignature signature) {
            this.onePassSignatures.put(signature.getKeyID(), signature);
        }

        int numVerifiableSignatures() {
            return this.onePassSignatures.size();
        }

        boolean hasVerifiableSignatures() {
            return this.numVerifiableSignatures() > 0;
        }
    }
}

