/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks;

import java.io.IOException;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.Rfc4880KeySelectionStrategy;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;

public class ByEMailKeySelectionStrategy
extends Rfc4880KeySelectionStrategy
implements KeySelectionStrategy {
    public ByEMailKeySelectionStrategy(Instant dateOfTimestampVerification) {
        super(dateOfTimestampVerification, true, true);
    }

    @Override
    protected Set<PGPPublicKeyRing> publicKeyRingsForUid(KeySelectionStrategy.PURPOSE purpose, String uid, KeyringConfig keyringConfig) throws IOException, PGPException {
        HashSet<PGPPublicKeyRing> keyringsForUid = new HashSet<PGPPublicKeyRing>();
        boolean uidAlreadyInBrackets = uid.matches(".*<.*>.*");
        String uidQuery = uidAlreadyInBrackets ? uid : "<" + uid + ">";
        Iterator keyRings = keyringConfig.getPublicKeyRings().getKeyRings(uidQuery, true, true);
        while (keyRings.hasNext()) {
            keyringsForUid.add((PGPPublicKeyRing)keyRings.next());
        }
        return keyringsForUid;
    }
}

