/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;

public enum KeyFlag {
    CERTIFY_OTHER(1),
    SIGN_DATA(2),
    ENCRYPT_COMMS(4),
    ENCRYPT_STORAGE(8),
    SPLIT(16),
    AUTHENTICATION(32),
    SHARED(128);

    private final int flag;

    private KeyFlag(int flag) {
        this.flag = flag;
    }

    public static Set<KeyFlag> fromInteger(int bitmask) {
        if (bitmask == 0) {
            return Collections.emptySet();
        }
        EnumSet<KeyFlag> flags = EnumSet.noneOf(KeyFlag.class);
        int identifiedFlags = 0;
        for (KeyFlag f : KeyFlag.values()) {
            if ((bitmask & f.flag) == 0) continue;
            flags.add(f);
            identifiedFlags |= f.flag;
        }
        if (identifiedFlags != bitmask) {
            int unknownFlags = ~identifiedFlags & bitmask;
            throw new IllegalArgumentException("Could not identify the following KeyFlags: 0b" + Long.toBinaryString(unknownFlags));
        }
        return Collections.unmodifiableSet(flags);
    }

    public static Optional<Set<KeyFlag>> extractPublicKeyFlags(PGPPublicKey publicKey) {
        Objects.requireNonNull(publicKey, "publicKey must not be null");
        int aggregatedKeyFlags = 0;
        boolean hasKeyFlags = false;
        Iterator directKeySignatures = publicKey.getSignatures();
        while (directKeySignatures.hasNext()) {
            PGPSignature signature = (PGPSignature)directKeySignatures.next();
            PGPSignatureSubpacketVector hashedSubPackets = signature.getHashedSubPackets();
            if (hashedSubPackets == null || !hashedSubPackets.hasSubpacket(27)) continue;
            hasKeyFlags = true;
            int keyFlags = hashedSubPackets.getKeyFlags();
            aggregatedKeyFlags |= keyFlags;
        }
        Optional<Set<KeyFlag>> publicKeyFlags = hasKeyFlags ? Optional.of(KeyFlag.fromInteger(aggregatedKeyFlags)) : Optional.empty();
        return publicKeyFlags;
    }

    public int getFlag() {
        return this.flag;
    }
}

