/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.algorithms.PGPHashAlgorithms;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallbacks;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeyFlag;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeyRingBuilder;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.KeySpec;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.Passphrase;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.SimpleKeyRingBuilder;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.internal.KeyRingSubKeyFixUtil;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.ECDHKeyType;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.ECDSAKeyType;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.KeyType;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.RSAKeyType;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.curve.EllipticCurve;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.generation.type.length.RsaLength;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.InMemoryKeyring;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfigs;
import name.neuhalfen.projects.crypto.internal.Preconditions;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class KeyRingBuilderImpl
implements KeyRingBuilder,
SimpleKeyRingBuilder {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final List<KeySpec> keySpecs = new ArrayList<KeySpec>();
    private String userId;
    private Passphrase passphrase;

    @Override
    public KeyringConfig simpleRsaKeyRing(String userId, RsaLength length) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException {
        Objects.requireNonNull(userId, "userId must not be null");
        Objects.requireNonNull(length, "length must not be null");
        return this.withSubKey(KeySpec.getBuilder(RSAKeyType.withLength(length)).allowKeyToBeUsedTo(KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms()).withSubKey(KeySpec.getBuilder(RSAKeyType.withLength(length)).allowKeyToBeUsedTo(KeyFlag.AUTHENTICATION).withDefaultAlgorithms()).withMasterKey(KeySpec.getBuilder(RSAKeyType.withLength(length)).allowKeyToBeUsedTo(KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA).withDefaultAlgorithms()).withPrimaryUserId(userId).withoutPassphrase().build();
    }

    @Override
    public KeyringConfig simpleEccKeyRing(String userId) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException {
        Objects.requireNonNull(userId, "userId must not be null");
        KeySpec encryptionKey = KeySpec.getBuilder(ECDHKeyType.fromCurve(EllipticCurve.CURVE_NIST_P256)).allowKeyToBeUsedTo(KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS).withDefaultAlgorithms();
        KeySpec authenticationKey = KeySpec.getBuilder(ECDHKeyType.fromCurve(EllipticCurve.CURVE_NIST_P256)).allowKeyToBeUsedTo(KeyFlag.AUTHENTICATION).withDefaultAlgorithms();
        KeySpec masterKey = KeySpec.getBuilder(ECDSAKeyType.fromCurve(EllipticCurve.CURVE_NIST_P256)).allowKeyToBeUsedTo(KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA).withDefaultAlgorithms();
        return this.withSubKey(encryptionKey).withSubKey(authenticationKey).withMasterKey(masterKey).withPrimaryUserId(userId).withoutPassphrase().build();
    }

    @Override
    public KeyRingBuilder withSubKey(KeySpec type) {
        Objects.requireNonNull(type, "type must not be null");
        this.keySpecs.add(type);
        return this;
    }

    @Override
    public KeyRingBuilder.WithPrimaryUserId withMasterKey(KeySpec spec) {
        Objects.requireNonNull(spec, "spec must not be null");
        Preconditions.checkArgument((spec.getSubpackets().getKeyFlags() & 1) != 0, "Certification Key MUST have KeyFlag CERTIFY_OTHER)");
        this.keySpecs.add(0, spec);
        return new WithPrimaryUserIdImpl();
    }

    class WithPrimaryUserIdImpl
    implements KeyRingBuilder.WithPrimaryUserId {
        WithPrimaryUserIdImpl() {
        }

        @Override
        public KeyRingBuilder.WithPassphrase withPrimaryUserId(String userId) {
            Objects.requireNonNull(userId, "userId must not be null");
            KeyRingBuilderImpl.this.userId = userId;
            return new WithPassphraseImpl();
        }

        @Override
        public KeyRingBuilder.WithPassphrase withPrimaryUserId(byte[] userId) {
            Objects.requireNonNull(userId, "userId must not be null");
            Preconditions.checkArgument(userId.length > 0, "userId mus have length >0");
            return this.withPrimaryUserId(new String(userId, UTF_8));
        }
    }

    class WithPassphraseImpl
    implements KeyRingBuilder.WithPassphrase {
        WithPassphraseImpl() {
        }

        @Override
        public KeyRingBuilder.Build withPassphrase(Passphrase passphrase) {
            Objects.requireNonNull(passphrase, "passphrase must not be null");
            KeyRingBuilderImpl.this.passphrase = passphrase;
            return new BuildImpl();
        }

        @Override
        public KeyRingBuilder.Build withoutPassphrase() {
            KeyRingBuilderImpl.this.passphrase = Passphrase.emptyPassphrase();
            return new BuildImpl();
        }

        private class BuildImpl
        implements KeyRingBuilder.Build {
            private BuildImpl() {
            }

            @Override
            public KeyringConfig build() throws NoSuchAlgorithmException, PGPException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException {
                PGPDigestCalculator calculator = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build().get(PGPHashAlgorithms.SHA1.getAlgorithmId());
                boolean withPassphrase = !KeyRingBuilderImpl.this.passphrase.isEmpty();
                PBESecretKeyEncryptor encryptor = withPassphrase ? new JcePBESecretKeyEncryptorBuilder(9, calculator).setProvider("BC").build(KeyRingBuilderImpl.this.passphrase.getChars()) : null;
                KeySpec certKeySpec = (KeySpec)KeyRingBuilderImpl.this.keySpecs.get(0);
                KeyRingBuilderImpl.this.keySpecs.remove(0);
                PGPKeyPair certKey = this.generateKeyPair(certKeySpec);
                JcaPGPContentSignerBuilder signer = new JcaPGPContentSignerBuilder(certKey.getPublicKey().getAlgorithm(), PGPHashAlgorithms.SHA_512.getAlgorithmId()).setProvider("BC");
                PGPSignatureSubpacketVector hashedSubPackets = certKeySpec.getSubpackets();
                PGPKeyRingGenerator ringGenerator = new PGPKeyRingGenerator(19, certKey, KeyRingBuilderImpl.this.userId, calculator, hashedSubPackets, null, (PGPContentSignerBuilder)signer, encryptor);
                for (KeySpec subKeySpec : KeyRingBuilderImpl.this.keySpecs) {
                    PGPKeyPair subKey = this.generateKeyPair(subKeySpec);
                    if (subKeySpec.isInheritedSubPackets()) {
                        ringGenerator.addSubKey(subKey);
                        continue;
                    }
                    ringGenerator.addSubKey(subKey, subKeySpec.getSubpackets(), null);
                }
                PGPPublicKeyRing publicKeys = ringGenerator.generatePublicKeyRing();
                PGPSecretKeyRing secretKeys = ringGenerator.generateSecretKeyRing();
                PBESecretKeyDecryptor decryptor = withPassphrase ? new JcePBESecretKeyDecryptorBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).build(KeyRingBuilderImpl.this.passphrase.getChars()) : null;
                secretKeys = KeyRingSubKeyFixUtil.repairSubkeyPackets(secretKeys, decryptor, encryptor);
                InMemoryKeyring keyring = KeyRingBuilderImpl.this.passphrase.isEmpty() ? KeyringConfigs.forGpgExportedKeys(KeyringConfigCallbacks.withUnprotectedKeys()) : KeyringConfigs.forGpgExportedKeys(KeyringConfigCallbacks.withPassword(KeyRingBuilderImpl.this.passphrase.getChars()));
                keyring.addSecretKeyRing(secretKeys);
                keyring.addPublicKeyRing(publicKeys);
                KeyRingBuilderImpl.this.passphrase.clear();
                return keyring;
            }

            private PGPKeyPair generateKeyPair(KeySpec spec) throws NoSuchProviderException, NoSuchAlgorithmException, PGPException, InvalidAlgorithmParameterException {
                KeyType type = spec.getKeyType();
                KeyPairGenerator certKeyGenerator = KeyPairGenerator.getInstance(type.getName(), "BC");
                certKeyGenerator.initialize(type.getAlgorithmSpec());
                KeyPair keyPair = certKeyGenerator.generateKeyPair();
                return new JcaPGPKeyPair(type.getAlgorithm().getAlgorithmId(), keyPair, new Date());
            }
        }
    }
}

