/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

abstract class AbstractDefaultKeyringConfig
implements KeyringConfig {
    @Nonnull
    private final KeyringConfigCallback callback;
    private final KeyFingerPrintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
    private PGPPublicKeyRingCollection publicKeyRings;
    private PGPSecretKeyRingCollection secretKeyRings;

    AbstractDefaultKeyringConfig(KeyringConfigCallback callback) {
        Objects.requireNonNull(callback, "callback must not be null");
        this.callback = callback;
    }

    public String toString() {
        return "AbstractDefaultKeyringConfig{" + "callback=" + this.callback + ", keyFingerPrintCalculator=" + this.keyFingerPrintCalculator + ", publicKeyRings=" + this.publicKeyRings + ", secretKeyRings=" + (this.secretKeyRings == null ? "null" : "<present>") + '}';
    }

    protected abstract InputStream getSecretKeyRingStream() throws IOException;

    protected abstract InputStream getPublicKeyRingStream() throws IOException;

    @Override
    public PGPPublicKeyRingCollection getPublicKeyRings() throws IOException, PGPException {
        if (this.publicKeyRings == null) {
            this.publicKeyRings = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)this.getPublicKeyRingStream()), this.keyFingerPrintCalculator);
        }
        return this.publicKeyRings;
    }

    @Override
    public PGPSecretKeyRingCollection getSecretKeyRings() throws IOException, PGPException {
        if (this.secretKeyRings == null) {
            this.secretKeyRings = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)this.getSecretKeyRingStream()), this.keyFingerPrintCalculator);
        }
        return this.secretKeyRings;
    }

    @Override
    @Nullable
    public char[] decryptionSecretKeyPassphraseForSecretKeyId(long keyID) {
        return this.callback.decryptionSecretKeyPassphraseForSecretKeyId(keyID);
    }

    @Override
    public KeyFingerPrintCalculator getKeyFingerPrintCalculator() {
        return this.keyFingerPrintCalculator;
    }
}

