/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

public final class InMemoryKeyring
implements KeyringConfig {
    @Nonnull
    private final KeyringConfigCallback callback;
    private final KeyFingerPrintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
    @Nonnull
    private PGPPublicKeyRingCollection publicKeyRings;
    @Nonnull
    private PGPSecretKeyRingCollection secretKeyRings;

    InMemoryKeyring(KeyringConfigCallback callback) throws IOException, PGPException {
        Objects.requireNonNull(callback, "callback must not be null");
        this.callback = callback;
        this.publicKeyRings = new PGPPublicKeyRingCollection((Collection)Collections.EMPTY_LIST);
        this.secretKeyRings = new PGPSecretKeyRingCollection((Collection)Collections.EMPTY_LIST);
    }

    public void addPublicKey(byte[] encodedPublicKey) throws IOException, PGPException {
        Objects.requireNonNull(encodedPublicKey, "encodedPublicKey must not be null");
        try (ByteArrayInputStream raw = new ByteArrayInputStream(encodedPublicKey);
             InputStream decoded = PGPUtil.getDecoderStream((InputStream)raw);){
            PGPPublicKeyRing pgpPub = new PGPPublicKeyRing(decoded, this.getKeyFingerPrintCalculator());
            this.addPublicKeyRing(pgpPub);
        }
    }

    public void addSecretKey(byte[] encodedPrivateKey) throws IOException, PGPException {
        Objects.requireNonNull(encodedPrivateKey, "encodedPrivateKey must not be null");
        try (ByteArrayInputStream raw = new ByteArrayInputStream(encodedPrivateKey);
             InputStream decoded = PGPUtil.getDecoderStream((InputStream)raw);){
            PGPSecretKeyRing pgpPRivate = new PGPSecretKeyRing(decoded, this.getKeyFingerPrintCalculator());
            this.addSecretKeyRing(pgpPRivate);
        }
    }

    public void addSecretKeyRing(PGPSecretKeyRing keyring) {
        Objects.requireNonNull(keyring, "keyring must not be null");
        this.secretKeyRings = PGPSecretKeyRingCollection.addSecretKeyRing((PGPSecretKeyRingCollection)this.secretKeyRings, (PGPSecretKeyRing)keyring);
    }

    public void addPublicKeyRing(PGPPublicKeyRing keyring) {
        Objects.requireNonNull(keyring, "keyring must not be null");
        this.publicKeyRings = PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)this.publicKeyRings, (PGPPublicKeyRing)keyring);
    }

    @Override
    @Nonnull
    public PGPPublicKeyRingCollection getPublicKeyRings() throws IOException, PGPException {
        return this.publicKeyRings;
    }

    @Override
    @Nonnull
    public PGPSecretKeyRingCollection getSecretKeyRings() throws IOException, PGPException {
        return this.secretKeyRings;
    }

    @Override
    @Nullable
    public char[] decryptionSecretKeyPassphraseForSecretKeyId(long keyID) {
        return this.callback.decryptionSecretKeyPassphraseForSecretKeyId(keyID);
    }

    @Override
    public KeyFingerPrintCalculator getKeyFingerPrintCalculator() {
        return this.keyFingerPrintCalculator;
    }
}

