/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

@Deprecated
final class StreamBasedKeyringConfig
implements KeyringConfig {
    @Nonnull
    private final KeyringConfigCallback callback;
    private final PGPPublicKeyRingCollection publicKeyRings;
    private final PGPSecretKeyRingCollection secretKeyRings;
    private final KeyFingerPrintCalculator keyFingerPrintCalculator;

    private StreamBasedKeyringConfig(KeyringConfigCallback callback, KeyFingerPrintCalculator keyFingerPrintCalculator, PGPPublicKeyRingCollection publicKeyRings, PGPSecretKeyRingCollection secretKeyRings) {
        this.callback = callback;
        this.keyFingerPrintCalculator = keyFingerPrintCalculator;
        this.publicKeyRings = publicKeyRings;
        this.secretKeyRings = secretKeyRings;
    }

    static KeyringConfig build(KeyringConfigCallback callback, @Nullable InputStream publicKeyringStream, @Nullable InputStream secretKeyringStream) throws IOException, PGPException {
        PGPSecretKeyRingCollection secretKeyRings;
        PGPPublicKeyRingCollection publicKeyRings;
        Objects.requireNonNull(callback, "callback must not be null");
        BcKeyFingerprintCalculator keyFingerPrintCalculator = new BcKeyFingerprintCalculator();
        if (publicKeyringStream == null) {
            publicKeyRings = new PGPPublicKeyRingCollection((Collection)Collections.EMPTY_LIST);
        } else {
            publicKeyRings = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)publicKeyringStream), (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            StreamBasedKeyringConfig.close(publicKeyringStream);
        }
        if (secretKeyringStream == null) {
            secretKeyRings = new PGPSecretKeyRingCollection((Collection)Collections.EMPTY_LIST);
        } else {
            secretKeyRings = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)secretKeyringStream), (KeyFingerPrintCalculator)keyFingerPrintCalculator);
            StreamBasedKeyringConfig.close(secretKeyringStream);
        }
        return new StreamBasedKeyringConfig(callback, (KeyFingerPrintCalculator)keyFingerPrintCalculator, publicKeyRings, secretKeyRings);
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "StreamBasedKeyringConfig{callback=" + this.callback + ", publicKeyRings=" + this.publicKeyRings + ", secretKeyRings=" + (this.secretKeyRings == null ? "null" : "<present>") + '}';
    }

    @Override
    public PGPPublicKeyRingCollection getPublicKeyRings() throws IOException, PGPException {
        return this.publicKeyRings;
    }

    @Override
    public PGPSecretKeyRingCollection getSecretKeyRings() throws IOException, PGPException {
        return this.secretKeyRings;
    }

    @Override
    @Nullable
    public char[] decryptionSecretKeyPassphraseForSecretKeyId(long keyID) {
        return this.callback.decryptionSecretKeyPassphraseForSecretKeyId(keyID);
    }

    @Override
    public KeyFingerPrintCalculator getKeyFingerPrintCalculator() {
        return this.keyFingerPrintCalculator;
    }
}

