/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.reencryption;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.reencryption.ZipEntityStrategy;

public class FSZipEntityStrategy
implements ZipEntityStrategy {
    private static final Pattern REMOVE_LEADING_RELATIVE_PATH = Pattern.compile("^(([.]{2,})|/|\\\\)*", 4);
    private static final Pattern REMOVE_DOT_DOT_REGEXP = Pattern.compile("[.]{2,}", 4);
    private static final Pattern REMOVE_FOLLOWING_REGEXP = Pattern.compile("[^a-zA-Z0-9_, +-./\\\\]", 4);
    private final File destRootDir;

    public FSZipEntityStrategy(File destRootDir) {
        this.destRootDir = destRootDir;
    }

    @Override
    public void handleDirectory(String sanitizedDirectoryName) throws IOException {
        Objects.requireNonNull(sanitizedDirectoryName, "sanitizedDirectoryName must not be null");
        File destPath = new File(this.destRootDir, sanitizedDirectoryName);
        boolean success = destPath.mkdir();
        if (!success) {
            throw new IOException("Failed to create '" + destPath + "'");
        }
    }

    @Override
    @Nullable
    public OutputStream createOutputStream(String sanitizedFileName) throws IOException {
        Objects.requireNonNull(sanitizedFileName, "sanitizedFileName must not be null");
        String fileName = sanitizedFileName + ".gpg";
        File destPath = new File(this.destRootDir, fileName);
        return Files.newOutputStream(destPath.toPath(), StandardOpenOption.CREATE_NEW);
    }

    @Override
    public String rewriteName(String nameFromZip) {
        Objects.requireNonNull(nameFromZip, "nameFromZip must not be null");
        String withOutLeadingRelativePath = REMOVE_LEADING_RELATIVE_PATH.matcher(nameFromZip).replaceAll("");
        String withoutDotDot = REMOVE_DOT_DOT_REGEXP.matcher(withOutLeadingRelativePath).replaceAll("");
        String sanitizedMiddlePart = REMOVE_FOLLOWING_REGEXP.matcher(withoutDotDot).replaceAll("");
        return sanitizedMiddlePart;
    }
}

