/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.symmetric.keygeneration;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import name.neuhalfen.projects.crypto.internal.Preconditions;
import name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.derivation.KeyDerivationFunction;

public class DerivedKeyGenerator {
    private static final int MAXIMUM_CONTEXT_ELEMENT_LENGTH = 65535;
    private final KeyDerivationFunction kdFwithMasterKeyMixin;
    @Nullable
    private final byte[] salt;

    public DerivedKeyGenerator(KeyDerivationFunction kdFwithMasterKeyMixin, @Nullable byte[] salt) {
        this.kdFwithMasterKeyMixin = kdFwithMasterKeyMixin;
        this.salt = salt == null ? null : Arrays.copyOf(salt, salt.length);
    }

    public byte[] deriveKey(String contextName, String idUniqueInContext, String recordVersion, int desiredKeyLengthBytes) throws GeneralSecurityException {
        String derivedKeyIdentifierStr = this.constructDerivedKeyIdentifier(contextName, idUniqueInContext, recordVersion);
        byte[] derivedKeyIdentifier = this.byteRepresentationOf(derivedKeyIdentifierStr);
        return this.kdFwithMasterKeyMixin.deriveKey(this.salt, derivedKeyIdentifier, desiredKeyLengthBytes * 8);
    }

    public String constructDerivedKeyIdentifier(@Nullable String contextName, String idUniqueInContext, String recordVersion) {
        if (contextName == null) {
            contextName = "";
        }
        Preconditions.checkArgument(contextName.length() <= 65535, "ContextName must be <= 65535 chars");
        Objects.requireNonNull(idUniqueInContext, "idUniqueInContext must not be null");
        Preconditions.checkArgument(!idUniqueInContext.isEmpty(), "idUniqueInContext must not be empty");
        Preconditions.checkArgument(idUniqueInContext.length() <= 65535, "idUniqueInContext must be <= 65535 chars");
        Objects.requireNonNull(recordVersion, "recordVersion must not be null");
        Preconditions.checkArgument(!recordVersion.isEmpty(), "recordVersion must not be empty");
        Preconditions.checkArgument(recordVersion.length() <= 65535, "recordVersion must be <= 65535 chars");
        return String.format("%04x:%s:%04x:%s:%04x:%s", contextName.length(), contextName, idUniqueInContext.length(), idUniqueInContext, recordVersion.length(), recordVersion);
    }

    private byte[] byteRepresentationOf(String identifier) {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(identifier));
        byte[] identifierByteRepresentation = new byte[buffer.limit()];
        buffer.get(identifierByteRepresentation);
        return identifierByteRepresentation;
    }
}

