/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.stretching;

import java.io.Serializable;
import java.util.Objects;
import name.neuhalfen.projects.crypto.internal.Preconditions;
import name.neuhalfen.projects.crypto.symmetric.keygeneration.impl.stretching.KeyStretching;
import org.bouncycastle.crypto.generators.SCrypt;

public class SCryptKeyStretching
implements KeyStretching {
    private final SCryptKeyStretchingParameters cfg;

    public SCryptKeyStretching(SCryptKeyStretchingParameters cfg) {
        this.cfg = cfg;
    }

    public static SCryptKeyStretching forConfig(SCryptKeyStretchingParameters cfg) {
        return new SCryptKeyStretching(cfg);
    }

    @Override
    public byte[] strengthenKey(byte[] salt, byte[] keyToStrengthen, int desiredKeyLengthInBit) {
        Preconditions.checkArgument(desiredKeyLengthInBit % 8 == 0, "desiredKeyLengthInBits must be multiple of 8 but is " + desiredKeyLengthInBit);
        int desiredKeyLengthInBytes = desiredKeyLengthInBit / 8;
        return SCrypt.generate((byte[])keyToStrengthen, (byte[])salt, (int)this.cfg.getN(), (int)this.cfg.getR(), (int)this.cfg.getP(), (int)desiredKeyLengthInBytes);
    }

    public static final class SCryptKeyStretchingParameters
    implements Serializable {
        private static final long serialVersionUID = 3949486467011133166L;
        private final int N;
        private final int r;
        private final int p;

        public SCryptKeyStretchingParameters(int N, int r, int p) {
            this.N = N;
            this.r = r;
            this.p = p;
        }

        public static SCryptKeyStretchingParameters forWeakInputKeyMaterial() {
            return new SCryptKeyStretchingParameters(0x100000, 8, 1);
        }

        public static SCryptKeyStretchingParameters forModeratelyStongInputKeyMaterial() {
            return new SCryptKeyStretchingParameters(4096, 4, 1);
        }

        public static SCryptKeyStretchingParameters forStrongInputKeyMaterial() {
            return new SCryptKeyStretchingParameters(256, 4, 1);
        }

        public int getN() {
            return this.N;
        }

        public int getR() {
            return this.r;
        }

        public int getP() {
            return this.p;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SCryptKeyStretchingParameters that = (SCryptKeyStretchingParameters)o;
            return this.N == that.N && this.r == that.r && this.p == that.p;
        }

        public int hashCode() {
            return Objects.hash(this.N, this.r, this.p);
        }

        public String toString() {
            return "PBKDF2KeyStretchingParameters{N=" + this.N + ", r=" + this.r + ", p=" + this.p + '}';
        }
    }
}

