/*
 * Decompiled with CFR 0.152.
 */
package extractor.javassist;

import extractor.javassist.ClassPool;
import extractor.javassist.CtClass;
import extractor.javassist.CtConstructor;
import extractor.javassist.CtMethod;
import extractor.javassist.NotFoundException;

final class CtArray
extends CtClass {
    protected ClassPool pool;
    private CtClass[] interfaces = null;

    CtArray(String name, ClassPool cp) {
        super(name);
        this.pool = cp;
    }

    public ClassPool getClassPool() {
        return this.pool;
    }

    public boolean isArray() {
        return true;
    }

    public int getModifiers() {
        int mod = 16;
        try {
            mod |= this.getComponentType().getModifiers() & 7;
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return mod;
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        if (this.interfaces == null) {
            this.interfaces = new CtClass[]{this.pool.get("java.lang.Cloneable"), this.pool.get("java.io.Serializable")};
        }
        return this.interfaces;
    }

    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        if (super.subtypeOf(clazz)) {
            return true;
        }
        String cname = clazz.getName();
        if (cname.equals("java.lang.Object") || cname.equals("java.lang.Cloneable") || cname.equals("java.io.Serializable")) {
            return true;
        }
        return clazz.isArray() && this.getComponentType().subtypeOf(clazz.getComponentType());
    }

    public CtClass getComponentType() throws NotFoundException {
        String name = this.getName();
        return this.pool.get(name.substring(0, name.length() - 2));
    }

    public CtClass getSuperclass() throws NotFoundException {
        return this.pool.get("java.lang.Object");
    }

    public CtMethod[] getMethods() {
        try {
            return this.getSuperclass().getMethods();
        }
        catch (NotFoundException e) {
            return super.getMethods();
        }
    }

    public CtMethod getMethod(String name, String desc) throws NotFoundException {
        return this.getSuperclass().getMethod(name, desc);
    }

    public CtConstructor[] getConstructors() {
        try {
            return this.getSuperclass().getConstructors();
        }
        catch (NotFoundException e) {
            return super.getConstructors();
        }
    }
}

