/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import javax.inject.Inject;
import name.remal.gradle_plugins.jacoco_to_cobertura.JacocoToCoberturaTransformer;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.PathUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class JacocoToCobertura
extends DefaultTask {
    public JacocoToCobertura() {
        this.onlyIf(__ -> {
            File jacocoReportFile = (File)this.getJacocoReport().getLocationOnly().map(RegularFile::getAsFile).getOrNull();
            return jacocoReportFile != null && jacocoReportFile.exists();
        });
        this.getCoberturaReport().convention(this.getProviders().provider(() -> {
            File jacocoReportFile = (File)this.getJacocoReport().getLocationOnly().map(RegularFile::getAsFile).getOrNull();
            if (jacocoReportFile == null) {
                return null;
            }
            File parentFile = jacocoReportFile.getParentFile();
            String fileName = jacocoReportFile.getName();
            File resultFile = parentFile != null ? new File(parentFile, "cobertura-" + fileName) : new File("cobertura-" + fileName);
            return ((Directory)this.getLayout().getBuildDirectory().get()).file(resultFile.getAbsolutePath());
        }));
    }

    @SkipWhenEmpty
    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getJacocoReport();

    @Optional
    @InputFiles
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSourceDirectories();

    @OutputFile
    public abstract RegularFileProperty getCoberturaReport();

    @TaskAction
    public void execute() {
        Path coberturaReportPath = (Path)this.getCoberturaReport().getLocationOnly().map(RegularFile::getAsFile).map(File::toPath).map(PathUtils::normalizePath).get();
        Files.deleteIfExists(coberturaReportPath);
        Path jacocoReportPath = (Path)this.getJacocoReport().getLocationOnly().map(RegularFile::getAsFile).map(File::toPath).map(PathUtils::normalizePath).get();
        if (!Files.exists(jacocoReportPath, new LinkOption[0])) {
            return;
        }
        JacocoToCoberturaTransformer.transformJacocoToCobertura(jacocoReportPath, coberturaReportPath, this.getSourceDirectories().getFiles().stream().map(File::getAbsolutePath).collect(Collectors.toList()));
    }

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ProjectLayout getLayout();
}

