/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura;

import java.util.Objects;
import name.remal.gradle_plugins.jacoco_to_cobertura.JacocoToCobertura;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.ExtensionContainerUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.ObjectUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.TaskUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.testing.jacoco.tasks.JacocoReport;

public class JacocoToCoberturaPlugin
implements Plugin<Project> {
    public static final String JACOCO_TO_COBERTURA_TASK_EXTENSION_NAME = ObjectUtils.doNotInline("jacocoToCoberturaTask");

    /*
     * WARNING - void declaration
     */
    public void apply(Project project) {
        void project2;
        Objects.requireNonNull(project, "project must not be null");
        TaskContainer tasks = project2.getTasks();
        tasks.withType(JacocoReport.class).all(JacocoToCoberturaPlugin::configureJacocoTask);
    }

    private static void configureJacocoTask(JacocoReport jacocoTask) {
        JacocoToCoberturaPlugin.enableJacocoXmlReport(jacocoTask);
        TaskUtils.doBeforeTaskExecution(jacocoTask, JacocoToCoberturaPlugin::enableJacocoXmlReport);
        TaskProvider coberturaTaskProvider = jacocoTask.getProject().getTasks().register(jacocoTask.getName() + "ToCobertura", JacocoToCobertura.class, coberturaTask -> {
            coberturaTask.setDescription(String.format("Convert XML report of `%s` task in Cobertura format", jacocoTask.getName()));
            coberturaTask.dependsOn(new Object[]{jacocoTask});
            coberturaTask.getJacocoReport().set(jacocoTask.getReports().getXml().getOutputLocation().getLocationOnly());
            coberturaTask.getSourceDirectories().from(new Object[]{jacocoTask.getSourceDirectories()});
            coberturaTask.getSourceDirectories().from(new Object[]{jacocoTask.getAdditionalSourceDirs()});
        });
        jacocoTask.finalizedBy(new Object[]{coberturaTaskProvider});
        ExtensionContainerUtils.getExtensions(jacocoTask).add((TypeOf)new TypeOf<TaskProvider<JacocoToCobertura>>(){}, JACOCO_TO_COBERTURA_TASK_EXTENSION_NAME, (Object)coberturaTaskProvider);
    }

    private static void enableJacocoXmlReport(JacocoReport jacocoTask) {
        jacocoTask.getReports().getXml().getRequired().set((Object)true);
    }
}

