/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.InTestFlags;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.PathUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.ResourceUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.SneakyThrowUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.UrlUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.ReflectionUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

abstract class JacocoToCoberturaTransformer {
    private static final Templates TEMPLATES;
    private static final boolean WITH_CUSTOM_ERROR_LISTENER = true;

    /*
     * WARNING - void declaration
     */
    public static void transformJacocoToCobertura(Path path, Path path2, Collection<String> collection) {
        void coberturaReportPath;
        void sources;
        Path jacocoReportPath;
        Objects.requireNonNull(path, "jacocoReportPath must not be null");
        Objects.requireNonNull(path2, "coberturaReportPath must not be null");
        Objects.requireNonNull(collection, "sources must not be null");
        Document jacocoReportDocument = XmlUtils.parseXml(jacocoReportPath);
        DOMSource transformSource = new DOMSource(jacocoReportDocument, jacocoReportPath.toString());
        DOMResult transformResult = new DOMResult();
        TEMPLATES.newTransformer().transform(transformSource, transformResult);
        Document document = (Document)transformResult.getNode();
        Element documentElement = document.getDocumentElement();
        Element sourcesNode = document.createElement("sources");
        documentElement.insertBefore(sourcesNode, documentElement.getFirstChild());
        sources.stream().filter(Objects::nonNull).distinct().forEach(source -> {
            Element sourceNode = document.createElement("source");
            sourceNode.setTextContent((String)source);
            sourcesNode.appendChild(sourceNode);
        });
        try (OutputStream outputStream = Files.newOutputStream(PathUtils.createParentDirectories((Path)coberturaReportPath), new OpenOption[0]);){
            String documentString = InTestFlags.isInTest() ? XmlUtils.prettyXmlString(document) : XmlUtils.compactXmlString(document);
            outputStream.write(documentString.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static void tryToSetAttribute(TransformerFactory factory, String name, Object value) {
        try {
            factory.setAttribute(name, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (value instanceof Boolean) {
            try {
                factory.setFeature(name, (Boolean)value);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                // empty catch block
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private JacocoToCoberturaTransformer() {
    }

    static {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setErrorListener(new ErrorListener(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void fatalError(TransformerException transformerException) throws TransformerException {
                void exception;
                Objects.requireNonNull(transformerException, "exception must not be null");
                throw exception;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void error(TransformerException transformerException) throws TransformerException {
                void exception;
                Objects.requireNonNull(transformerException, "exception must not be null");
                this.fatalError((TransformerException)exception);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void warning(TransformerException transformerException) throws TransformerException {
                void exception;
                Objects.requireNonNull(transformerException, "exception must not be null");
                this.error((TransformerException)exception);
            }
        });
        transformerFactory.setURIResolver((href, base) -> {
            throw new UnsupportedOperationException();
        });
        JacocoToCoberturaTransformer.tryToSetAttribute(transformerFactory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        JacocoToCoberturaTransformer.tryToSetAttribute(transformerFactory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        JacocoToCoberturaTransformer.tryToSetAttribute(transformerFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        JacocoToCoberturaTransformer.tryToSetAttribute(transformerFactory, "package-name", ReflectionUtils.packageNameOf(JacocoToCoberturaTransformer.class));
        URL xsltFileUrl = ResourceUtils.getResourceUrl("jacoco-to-cobertura.xsl", JacocoToCoberturaTransformer.class);
        try (InputStream inputStream = UrlUtils.openInputStreamForUrl(xsltFileUrl);){
            StreamSource source = new StreamSource(inputStream, xsltFileUrl.toString());
            TEMPLATES = transformerFactory.newTemplates(source);
        }
        catch (Exception e) {
            throw SneakyThrowUtils.sneakyThrow(e);
        }
    }
}

