/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.CrossCompileServiceDependencyVersion;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.CrossCompileServiceImpl;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.CrossCompileServiceLoadingException;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.CrossCompileVersionComparator;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.CrossCompileVersionComparisonResult;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.FunctionUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.PredicateUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.ResourceNotFoundException;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.ResourceUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.UrlUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.Version;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.com.google.common.annotations.VisibleForTesting;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.com.google.common.base.Splitter;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.objectweb.asm.AnnotationVisitor;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.objectweb.asm.ClassReader;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.objectweb.asm.ClassVisitor;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.objectweb.asm.tree.ClassNode;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.ReflectionUtils;
import org.gradle.api.JavaVersion;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class CrossCompileServices {
    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private static final Logger logger = Logging.getLogger(CrossCompileServices.class);
    private static final CrossCompileVersionComparator DEFAULT_VERSION_COMPARATOR = CrossCompileVersionComparator.standardVersionCrossCompileVersionComparator("gradle", GradleVersion.current().getVersion()).then(CrossCompileVersionComparator.standardVersionCrossCompileVersionComparator("java", JavaVersion.current().getMajorVersion()));

    public static synchronized <T> T loadCrossCompileService(Class<T> clazz) {
        Class<T> service;
        Objects.requireNonNull(clazz, "service must not be null");
        return CrossCompileServices.loadCrossCompileService(service, null);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized <T> T loadCrossCompileService(Class<T> clazz, @Nullable CrossCompileVersionComparator crossCompileVersionComparator) {
        void dependencyVersionComparator;
        Class<T> service;
        Objects.requireNonNull(clazz, "service must not be null");
        Set<String> implClassNames = CrossCompileServices.getImplClassNames(service);
        List<CrossCompileServiceImpl> impls = CrossCompileServices.parseServiceImpls(service, implClassNames);
        CrossCompileServiceImpl fallbackImpl = CrossCompileServices.extractFallbackImpl(service, impls);
        impls.removeIf(impl -> impl.getDependencyVersion().isNothingIncluded());
        CrossCompileServices.assertNoIntersections(service, impls);
        CrossCompileVersionComparator dependencyVersionComparatorWithDefault = CrossCompileServices.withDefaultCrossCompileVersionComparator((CrossCompileVersionComparator)dependencyVersionComparator);
        CrossCompileServiceImpl impl2 = CrossCompileServices.getImpl(impls, dependencyVersionComparatorWithDefault);
        if (impl2 == null) {
            impl2 = fallbackImpl;
        }
        try {
            Class<?> implClass = Class.forName(impl2.getClassName(), true, service.getClassLoader());
            Constructor<?> implCtor = implClass.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(implCtor);
            Object implInstance = implCtor.newInstance(new Object[0]);
            return service.cast(implInstance);
        }
        catch (Throwable exception) {
            throw new CrossCompileServiceLoadingException(String.format("Error instantiating cross-compile implementation of %s: %s", service.getName(), impl2), exception);
        }
    }

    public static synchronized <T> @Unmodifiable List<T> loadAllCrossCompileServiceImplementations(Class<T> clazz) {
        Class<T> service;
        Objects.requireNonNull(clazz, "service must not be null");
        return CrossCompileServices.loadAllCrossCompileServiceImplementations(service, null);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized <T> @Unmodifiable List<T> loadAllCrossCompileServiceImplementations(Class<T> clazz, @Nullable CrossCompileVersionComparator crossCompileVersionComparator) {
        void dependencyVersionComparator;
        Class<T> service;
        Objects.requireNonNull(clazz, "service must not be null");
        Set<String> implClassNames = CrossCompileServices.getImplClassNames(service);
        List<CrossCompileServiceImpl> impls = CrossCompileServices.parseServiceImpls(service, implClassNames);
        CrossCompileVersionComparator dependencyVersionComparatorWithDefault = CrossCompileServices.withDefaultCrossCompileVersionComparator((CrossCompileVersionComparator)dependencyVersionComparator);
        List activeImpls = impls.stream().filter(impl -> impl.isFallback() || CrossCompileServices.isActive(impl, dependencyVersionComparatorWithDefault)).collect(Collectors.toList());
        ArrayList<T> instances = new ArrayList<T>(impls.size());
        for (CrossCompileServiceImpl impl2 : activeImpls) {
            try {
                Class<?> implClass = Class.forName(impl2.getClassName(), true, service.getClassLoader());
                Constructor<?> implCtor = implClass.getDeclaredConstructor(new Class[0]);
                ReflectionUtils.makeAccessible(implCtor);
                Object implInstance = implCtor.newInstance(new Object[0]);
                T instance = service.cast(implInstance);
                instances.add(instance);
            }
            catch (Throwable exception) {
                throw new CrossCompileServiceLoadingException(String.format("Error instantiating cross-compile implementation of %s: %s", service.getName(), impl2), exception);
            }
        }
        return Collections.unmodifiableList(instances);
    }

    private static CrossCompileVersionComparator withDefaultCrossCompileVersionComparator(@Nullable CrossCompileVersionComparator dependencyVersionComparator) {
        if (dependencyVersionComparator == null) {
            return DEFAULT_VERSION_COMPARATOR;
        }
        return dependencyVersionComparator.then(DEFAULT_VERSION_COMPARATOR);
    }

    private static Set<String> getImplClassNames(Class<?> service) {
        LinkedHashSet<String> implClassNames = new LinkedHashSet<String>();
        String resourceName = "META-INF/services/" + service.getName();
        Enumeration<URL> resourceUrls = Objects.requireNonNull(service.getClassLoader()).getResources(resourceName);
        while (resourceUrls.hasMoreElements()) {
            URL resourceUrl = resourceUrls.nextElement();
            String content = UrlUtils.readStringFromUrl(resourceUrl, StandardCharsets.UTF_8);
            Splitter.onPattern("[\\r\\n]+").splitToStream(content).map(FunctionUtils.toSubstringedBefore("#")).map(String::trim).filter(PredicateUtils.not(String::isEmpty)).forEach(implClassNames::add);
        }
        return implClassNames;
    }

    private static List<CrossCompileServiceImpl> parseServiceImpls(Class<?> loadingClass, Collection<String> implClassNames) {
        LinkedHashMap<String, CrossCompileServiceDependencyVersion> versionInfos = new LinkedHashMap<String, CrossCompileServiceDependencyVersion>();
        for (final String implClassName : implClassNames) {
            byte[] implClassBytecode;
            try {
                implClassBytecode = ResourceUtils.readResource(implClassName.replace('.', '/') + ".class", loadingClass.getClassLoader());
            }
            catch (ResourceNotFoundException ignored) {
                logger.error("Cross-compile implementation class not found: {}", (Object)implClassName);
                continue;
            }
            final CrossCompileServiceDependencyVersion.CrossCompileServiceDependencyVersionBuilder dependencyVersionInfoBuilder = CrossCompileServiceDependencyVersion.builder();
            final AtomicBoolean isProcessed = new AtomicBoolean();
            final int asmApi = CrossCompileServices.getAsmApi();
            ClassVisitor classVisitor = new ClassVisitor(asmApi){

                @Override
                @Nullable
                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if (descriptor.endsWith("/RemalGradlePluginsCrossCompilation;") && isProcessed.compareAndSet(false, true)) {
                        return new AnnotationVisitor(asmApi){

                            @Override
                            public void visit(String name, Object value) {
                                block5 : switch (name) {
                                    case "dependency": {
                                        dependencyVersionInfoBuilder.dependency(value.toString());
                                        break;
                                    }
                                    case "version": {
                                        dependencyVersionInfoBuilder.version(Version.parse(value.toString()));
                                        break;
                                    }
                                    case "versionOperator": {
                                        String versionOperator;
                                        switch (versionOperator = value.toString()) {
                                            case "lt": {
                                                dependencyVersionInfoBuilder.earlierIncluded(true);
                                                break block5;
                                            }
                                            case "lte": {
                                                dependencyVersionInfoBuilder.earlierIncluded(true).selfIncluded(true);
                                                break block5;
                                            }
                                            case "eq": {
                                                dependencyVersionInfoBuilder.selfIncluded(true);
                                                break block5;
                                            }
                                            case "gte": {
                                                dependencyVersionInfoBuilder.selfIncluded(true).laterIncluded(true);
                                                break block5;
                                            }
                                            case "gt": {
                                                dependencyVersionInfoBuilder.laterIncluded(true);
                                                break block5;
                                            }
                                        }
                                        logger.error("Unsupported cross-compile 'versionOperator' parameter for {}: {}", (Object)implClassName, (Object)versionOperator);
                                        break;
                                    }
                                    default: {
                                        logger.error("Unsupported cross-compile '{}' parameter for {}", (Object)name, (Object)implClassName);
                                    }
                                }
                            }
                        };
                    }
                    return null;
                }
            };
            new ClassReader(implClassBytecode).accept(classVisitor, 7);
            CrossCompileServiceDependencyVersion dependencyVersionInfo = dependencyVersionInfoBuilder.build();
            Version version = dependencyVersionInfo.getVersion();
            if (version != null) {
                String dependency = (dependencyVersionInfo = dependencyVersionInfo.withVersion(version.withoutSuffix())).getDependency();
                if (dependency.equals("java")) {
                    dependencyVersionInfo = dependencyVersionInfo.withMaxVersionNumbersCount(1);
                } else if (dependency.equals("gradle")) {
                    dependencyVersionInfo = dependencyVersionInfo.withMaxVersionNumbersCount(3);
                }
            }
            versionInfos.put(implClassName, dependencyVersionInfo);
        }
        return versionInfos.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> CrossCompileServiceImpl.builder().className((String)entry.getKey()).dependencyVersion((CrossCompileServiceDependencyVersion)entry.getValue()).build()).collect(Collectors.toCollection(ArrayList::new));
    }

    private static int getAsmApi() {
        Field field = ClassVisitor.class.getDeclaredField("api");
        ReflectionUtils.makeAccessible(field);
        return field.getInt(new ClassNode());
    }

    private static CrossCompileServiceImpl extractFallbackImpl(Class<?> service, List<CrossCompileServiceImpl> impls) {
        List fallbackImpls = impls.stream().filter(CrossCompileServiceImpl::isFallback).collect(Collectors.toList());
        if (fallbackImpls.isEmpty()) {
            throw new CrossCompileServiceLoadingException(String.format("Cross-compile fallback implementation not found for %s", service));
        }
        if (fallbackImpls.size() >= 2) {
            throw new CrossCompileServiceLoadingException(String.format("Multiple cross-compile fallback implementations found for %s: %s", service, fallbackImpls.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        CrossCompileServiceImpl fallbackImpl = (CrossCompileServiceImpl)fallbackImpls.get(0);
        impls.remove(fallbackImpl);
        return fallbackImpl;
    }

    private static void assertNoIntersections(Class<?> service, List<CrossCompileServiceImpl> impls) {
        for (int i = 0; i < impls.size() - 1; ++i) {
            for (int g = i + 1; g < impls.size(); ++g) {
                CrossCompileServiceImpl thisImpl = impls.get(i);
                CrossCompileServiceImpl thatImpl = impls.get(g);
                if (!thisImpl.getDependencyVersion().intersectsWith(thatImpl.getDependencyVersion())) continue;
                throw new CrossCompileServiceLoadingException(String.format("Cross-compile implementation versions intersect for %s: %s, %s", service, thisImpl, thatImpl));
            }
        }
    }

    @Nullable
    private static CrossCompileServiceImpl getImpl(List<CrossCompileServiceImpl> impls, CrossCompileVersionComparator dependencyVersionComparator) {
        boolean isActive;
        List onlySelfIncludedImpls = impls.stream().filter(impl -> impl.getDependencyVersion().isOnlySelfIncluded()).collect(Collectors.toList());
        for (CrossCompileServiceImpl impl2 : onlySelfIncludedImpls) {
            isActive = CrossCompileServices.isActive(impl2, dependencyVersionComparator);
            if (!isActive) continue;
            return impl2;
        }
        List earlierIncludedImpls = impls.stream().filter(impl -> impl.getDependencyVersion().isEarlierIncluded()).sorted(Comparator.comparing(CrossCompileServiceImpl::getDependencyVersion)).collect(Collectors.toList());
        for (CrossCompileServiceImpl impl2 : earlierIncludedImpls) {
            isActive = CrossCompileServices.isActive(impl2, dependencyVersionComparator);
            if (!isActive) continue;
            return impl2;
        }
        List laterIncludedImpls = impls.stream().filter(impl -> impl.getDependencyVersion().isLaterIncluded()).filter(PredicateUtils.not(impl -> impl.getDependencyVersion().isEarlierIncluded())).sorted(Comparator.comparing(CrossCompileServiceImpl::getDependencyVersion).reversed()).collect(Collectors.toList());
        for (CrossCompileServiceImpl impl2 : laterIncludedImpls) {
            isActive = CrossCompileServices.isActive(impl2, dependencyVersionComparator);
            if (!isActive) continue;
            return impl2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static boolean isActive(CrossCompileServiceImpl crossCompileServiceImpl, CrossCompileVersionComparator crossCompileVersionComparator) {
        void dependencyVersionComparator;
        CrossCompileServiceImpl impl;
        Objects.requireNonNull(crossCompileServiceImpl, "impl must not be null");
        Objects.requireNonNull(crossCompileVersionComparator, "dependencyVersionComparator must not be null");
        String className = impl.getClassName();
        CrossCompileServiceDependencyVersion dependencyVersion = impl.getDependencyVersion();
        String dependency = dependencyVersion.getDependency();
        Version version = Objects.requireNonNull(dependencyVersion.getVersion()).withoutSuffix();
        boolean earlierIncluded = dependencyVersion.isEarlierIncluded();
        boolean selfIncluded = dependencyVersion.isSelfIncluded();
        boolean laterIncluded = dependencyVersion.isLaterIncluded();
        CrossCompileVersionComparisonResult comparisonResult = dependencyVersionComparator.compareDependencyVersionToCurrentVersion(dependency, version.toString());
        if (comparisonResult == null) {
            logger.error("Unsupported cross-compile dependency for {}: {}", (Object)className, (Object)dependencyVersion);
            return false;
        }
        if (comparisonResult == CrossCompileVersionComparisonResult.DEPENDENCY_GREATER_THAN_CURRENT) {
            return earlierIncluded;
        }
        if (comparisonResult == CrossCompileVersionComparisonResult.DEPENDENCY_EQUALS_TO_CURRENT) {
            return selfIncluded;
        }
        if (comparisonResult == CrossCompileVersionComparisonResult.DEPENDENCY_LESS_THAN_CURRENT) {
            return laterIncluded;
        }
        throw new UnsupportedOperationException("Unsupported comparison result: " + (Object)((Object)comparisonResult));
    }

    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private CrossCompileServices() {
    }
}

