/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit;

import com.google.errorprone.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.meta.When;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.annotations.ReliesOnInternalGradleApi;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.apache.commons.lang3.ObjectUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@ReliesOnInternalGradleApi
public abstract class DebugUtils {
    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private static final Logger logger = Logging.getLogger(DebugUtils.class);
    private static final boolean IS_DEBUG_ENABLED = ManagementFactory.getRuntimeMXBean().getInputArguments().stream().anyMatch(arg -> arg.startsWith("-agentlib:jdwp="));
    private static final long MAX_NANOS_TO_DISPLAY_IN_NANOS = Duration.ofMillis(1L).toNanos();
    private static final long MAX_NANOS_TO_DISPLAY_IN_MILLIS = Duration.ofMinutes(1L).toNanos();

    public static boolean isDebugEnabled() {
        return IS_DEBUG_ENABLED;
    }

    public static void ifDebugEnabled(IfDebugEnabled ifDebugEnabled) {
        Objects.requireNonNull(ifDebugEnabled, "action must not be null");
        if (DebugUtils.isDebugEnabled()) {
            IfDebugEnabled action;
            action.execute();
        }
    }

    public static void dumpClassLoaderToLog(@Nullable ClassLoader classLoader) {
        logger.quiet(DebugUtils.dumpClassLoader(classLoader));
    }

    @CheckReturnValue
    public static String dumpClassLoader(@Nullable ClassLoader classLoader) {
        StringBuilder message = new StringBuilder();
        DebugUtils.dumpClassLoader(message, classLoader);
        return message.toString();
    }

    @ReliesOnInternalGradleApi
    private static void dumpClassLoader(final StringBuilder message, @Nullable ClassLoader classLoader) {
        if (message.length() > 0) {
            message.append('\n');
        }
        message.append(classLoader);
        if (classLoader == null) {
            return;
        }
        if (classLoader instanceof ClassLoaderHierarchy) {
            ((ClassLoaderHierarchy)classLoader).visit(new ClassLoaderVisitor(){

                public void visitSpec(ClassLoaderSpec spec) {
                    message.append("\n  Spec: ").append(spec);
                }

                public void visitClassPath(URL[] urls) {
                    if (ObjectUtils.isEmpty(urls)) {
                        message.append("\n  Empty classpath");
                    } else {
                        message.append("\n  Classpath:");
                        for (URL url : urls) {
                            message.append("\n    ").append(url);
                        }
                    }
                }

                public void visitParent(ClassLoader classLoader) {
                }
            });
        } else if (classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            if (ObjectUtils.isEmpty(urls)) {
                message.append("\n  Empty classpath");
            } else {
                message.append("\n  Classpath:");
                for (URL url : urls) {
                    message.append("\n    ").append(url);
                }
            }
        }
        ClassLoader parentClassLoader = classLoader.getParent();
        if (parentClassLoader != null) {
            DebugUtils.dumpClassLoader(message, parentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull(when=When.UNKNOWN)
    public static <T> T logTiming(String string, Callable<T> callable) {
        String timerName;
        Object v;
        Objects.requireNonNull(string, "timerName must not be null");
        Objects.requireNonNull(callable, "action must not be null");
        long startNanos = System.nanoTime();
        try {
            void action;
            v = action.call();
        }
        catch (Throwable throwable) {
            long durationNanos2 = System.nanoTime() - startNanos;
            if (durationNanos2 <= MAX_NANOS_TO_DISPLAY_IN_NANOS) {
                logger.quiet("{} took {} nanos", new Object[]{timerName, durationNanos2});
                throw throwable;
            }
            if (durationNanos2 <= MAX_NANOS_TO_DISPLAY_IN_MILLIS) {
                logger.quiet("{} took {} millis", new Object[]{timerName, TimeUnit.NANOSECONDS.toMillis(durationNanos2)});
                throw throwable;
            }
            logger.quiet("{} took {} seconds", new Object[]{timerName, TimeUnit.NANOSECONDS.toSeconds(durationNanos2)});
            throw throwable;
        }
        long durationNanos = System.nanoTime() - startNanos;
        if (durationNanos <= MAX_NANOS_TO_DISPLAY_IN_NANOS) {
            logger.quiet("{} took {} nanos", new Object[]{timerName, durationNanos});
            return (T)v;
        }
        if (durationNanos <= MAX_NANOS_TO_DISPLAY_IN_MILLIS) {
            logger.quiet("{} took {} millis", new Object[]{timerName, TimeUnit.NANOSECONDS.toMillis(durationNanos)});
            return (T)v;
        }
        logger.quiet("{} took {} seconds", new Object[]{timerName, TimeUnit.NANOSECONDS.toSeconds(durationNanos)});
        return (T)v;
    }

    /*
     * WARNING - void declaration
     */
    public static void logTiming(String string, Runnable runnable) {
        void action;
        String timerName;
        Objects.requireNonNull(string, "timerName must not be null");
        Objects.requireNonNull(runnable, "action must not be null");
        DebugUtils.logTiming(timerName, () -> DebugUtils.lambda$logTiming$1((Runnable)action));
    }

    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private DebugUtils() {
    }

    private static /* synthetic */ Object lambda$logTiming$1(Runnable action) throws Exception {
        action.run();
        return null;
    }

    @FunctionalInterface
    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    public static interface IfDebugEnabled {
        public void execute() throws Throwable;
    }
}

