/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit;

import com.google.errorprone.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import javax.annotation.Nullable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class PathUtils {
    private static final int DELETE_ATTEMPTS = 5;

    public static Path normalizePath(Path path) {
        File file;
        Path path2;
        Objects.requireNonNull(path, "path must not be null");
        try {
            file = path2.toFile();
        }
        catch (UnsupportedOperationException ignored1) {
            path2 = path2.toAbsolutePath().normalize();
            try {
                path2 = path2.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return path2;
        }
        return file.getCanonicalFile().toPath();
    }

    /*
     * WARNING - void declaration
     */
    public static void copyRecursively(Path path, Path path2, CopyOption ... copyOptionArray) {
        void options;
        void destination;
        Path source;
        Objects.requireNonNull(path, "source must not be null");
        Objects.requireNonNull(path2, "destination must not be null");
        Objects.requireNonNull(copyOptionArray, "options must not be null");
        final Path normalizedSource = PathUtils.normalizePath(source);
        final Path normalizedDestination = PathUtils.normalizePath((Path)destination);
        Files.walkFileTree(normalizedSource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((CopyOption[])options){
            final /* synthetic */ CopyOption[] val$options;
            {
                this.val$options = copyOptionArray;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(normalizedDestination.resolve(normalizedSource.relativize(dir).toString()), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, normalizedDestination.resolve(normalizedSource.relativize(file).toString()), this.val$options);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Nullable
    public static FileTime getPathLastModifiedIfExists(Path path) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            Path path2;
            return Files.getLastModifiedTime(path2, new LinkOption[0]);
        }
        catch (NoSuchFileException ignored) {
            return null;
        }
    }

    public static Path deleteRecursively(Path path) {
        Path path2;
        Objects.requireNonNull(path, "path must not be null");
        int attempt = 1;
        while (true) {
            try {
                Files.walkFileTree(PathUtils.normalizePath(path2), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.deleteIfExists(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.deleteIfExists(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (NoSuchFileException ignored) {
            }
            catch (FileSystemException e) {
                if (attempt >= 5) {
                    throw e;
                }
                System.gc();
                Thread.sleep(100L * (long)attempt);
                ++attempt;
                continue;
            }
            break;
        }
        return path2;
    }

    @CheckReturnValue
    public static boolean tryToDeleteRecursively(Path path) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            Path path2;
            PathUtils.deleteRecursively(path2);
            return true;
        }
        catch (Throwable e) {
            if (e instanceof FileSystemException) {
                return false;
            }
            throw e;
        }
    }

    public static Path createParentDirectories(Path path) {
        Path path2;
        Objects.requireNonNull(path, "path must not be null");
        Path parentPath = PathUtils.normalizePath(path2).getParent();
        if (parentPath != null) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        return path2;
    }

    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private PathUtils() {
    }
}

