/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@name.remal.gradle_plugins.dsl.internal.Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class StringUtils {
    private static final Pattern NEW_LINE = Pattern.compile("(\\r\\n)|(\\n\\r)|(\\r)|(\\n)");
    private static final Pattern TRIM_LINE_END = Pattern.compile("[ \\t]+(?:\\n|$)");
    private static final Pattern TOO_MANY_NEW_LINES = Pattern.compile("\\n{3,}");
    private static final Pattern INDENT_NEXT_LINE = Pattern.compile("\\n([^\\n])");
    private static final CharPredicate ALWAYS_FALSE_CHAR_PREDICATE = __ -> false;

    public static String normalizeNewLines(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return NEW_LINE.matcher(string2).replaceAll("\n");
    }

    public static String normalizeString(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        if (string2.isEmpty() || string2.trim().isEmpty()) {
            return "";
        }
        string2 = StringUtils.normalizeNewLines(string2);
        string2 = TRIM_LINE_END.matcher(string2).replaceAll("\n");
        string2 = TOO_MANY_NEW_LINES.matcher(string2).replaceAll("\n\n");
        while (string2.startsWith("\n")) {
            string2 = string2.substring(1);
        }
        while (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static String indentString(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringUtils.indentString(string2, 2);
    }

    /*
     * WARNING - void declaration
     */
    public static String indentString(String string, int n) {
        void indentSize;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        string2 = StringUtils.normalizeString(string2);
        if (string2.isEmpty()) {
            return "";
        }
        if (indentSize <= 0) {
            return string2;
        }
        StringBuilder indentBuilder = new StringBuilder((int)indentSize);
        for (int n2 = 1; n2 <= indentSize; ++n2) {
            indentBuilder.append(' ');
        }
        String indent = indentBuilder.toString();
        string2 = indent + INDENT_NEXT_LINE.matcher(string2).replaceAll("\n" + indent + "$1");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBefore(String string, String string2) {
        void stringToFind;
        String string3;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        return StringUtils.substringBefore(string3, (String)stringToFind, string3);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBefore(String string, String string2, String string3) {
        void missingString;
        String string4;
        void stringToFind;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        Objects.requireNonNull(string3, "missingString must not be null");
        if (stringToFind.isEmpty()) {
            throw new IllegalArgumentException("stringToFind must not be empty");
        }
        int pos = string4.indexOf((String)stringToFind);
        return pos >= 0 ? string4.substring(0, pos) : missingString;
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBeforeLast(String string, String string2) {
        void stringToFind;
        String string3;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        return StringUtils.substringBeforeLast(string3, (String)stringToFind, string3);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringBeforeLast(String string, String string2, String string3) {
        void missingString;
        String string4;
        void stringToFind;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        Objects.requireNonNull(string3, "missingString must not be null");
        if (stringToFind.isEmpty()) {
            throw new IllegalArgumentException("stringToFind must not be empty");
        }
        int pos = string4.lastIndexOf((String)stringToFind);
        return pos >= 0 ? string4.substring(0, pos) : missingString;
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfter(String string, String string2) {
        void stringToFind;
        String string3;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        return StringUtils.substringAfter(string3, (String)stringToFind, string3);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfter(String string, String string2, String string3) {
        void missingString;
        String string4;
        void stringToFind;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        Objects.requireNonNull(string3, "missingString must not be null");
        if (stringToFind.isEmpty()) {
            throw new IllegalArgumentException("stringToFind must not be empty");
        }
        int pos = string4.indexOf((String)stringToFind);
        return pos >= 0 ? string4.substring(pos + stringToFind.length()) : missingString;
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfterLast(String string, String string2) {
        void stringToFind;
        String string3;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        return StringUtils.substringAfterLast(string3, (String)stringToFind, string3);
    }

    /*
     * WARNING - void declaration
     */
    public static String substringAfterLast(String string, String string2, String string3) {
        void missingString;
        String string4;
        void stringToFind;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(string2, "stringToFind must not be null");
        Objects.requireNonNull(string3, "missingString must not be null");
        if (stringToFind.isEmpty()) {
            throw new IllegalArgumentException("stringToFind must not be empty");
        }
        int pos = string4.lastIndexOf((String)stringToFind);
        return pos >= 0 ? string4.substring(pos + stringToFind.length()) : missingString;
    }

    /*
     * WARNING - void declaration
     */
    public static String trimWith(String string, CharPredicate charPredicate) {
        void charPredicate2;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(charPredicate, "charPredicate must not be null");
        if (string2.isEmpty()) {
            return "";
        }
        if (charPredicate2 == ALWAYS_FALSE_CHAR_PREDICATE) {
            return string2;
        }
        int startPos = StringUtils.calculateTrimmedStartPos(string2, (CharPredicate)charPredicate2);
        if (startPos >= string2.length()) {
            return "";
        }
        int endPos = StringUtils.calculateTrimmedEndPos(string2, (CharPredicate)charPredicate2);
        return string2.substring(startPos, endPos + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String trimWith(String string, char ... cArray) {
        void charsToRemove;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(cArray, "charsToRemove must not be null");
        return StringUtils.trimWith(string2, StringUtils.charPredicateOf((char[])charsToRemove));
    }

    /*
     * WARNING - void declaration
     */
    public static String trimWith(String string, CharSequence charSequence) {
        void charsToRemove;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(charSequence, "charsToRemove must not be null");
        return StringUtils.trimWith(string2, StringUtils.charPredicateOf((CharSequence)charsToRemove));
    }

    /*
     * WARNING - void declaration
     */
    public static String trimLeftWith(String string, CharPredicate charPredicate) {
        void charPredicate2;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(charPredicate, "charPredicate must not be null");
        if (string2.isEmpty()) {
            return "";
        }
        if (charPredicate2 == ALWAYS_FALSE_CHAR_PREDICATE) {
            return string2;
        }
        int startPos = StringUtils.calculateTrimmedStartPos(string2, (CharPredicate)charPredicate2);
        if (startPos >= string2.length()) {
            return "";
        }
        int endPos = string2.length() - 1;
        return string2.substring(startPos, endPos + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String trimLeftWith(String string, char ... cArray) {
        void charsToRemove;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(cArray, "charsToRemove must not be null");
        return StringUtils.trimLeftWith(string2, StringUtils.charPredicateOf((char[])charsToRemove));
    }

    /*
     * WARNING - void declaration
     */
    public static String trimLeftWith(String string, CharSequence charSequence) {
        void charsToRemove;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(charSequence, "charsToRemove must not be null");
        return StringUtils.trimLeftWith(string2, StringUtils.charPredicateOf((CharSequence)charsToRemove));
    }

    public static String trimLeft(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringUtils.trimLeftWith(string2, Character::isWhitespace);
    }

    /*
     * WARNING - void declaration
     */
    public static String trimRightWith(String string, CharPredicate charPredicate) {
        void charPredicate2;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(charPredicate, "charPredicate must not be null");
        if (string2.isEmpty()) {
            return "";
        }
        if (charPredicate2 == ALWAYS_FALSE_CHAR_PREDICATE) {
            return string2;
        }
        boolean startPos = false;
        int endPos = StringUtils.calculateTrimmedEndPos(string2, (CharPredicate)charPredicate2);
        if (endPos < 0) {
            return "";
        }
        return string2.substring(0, endPos + 1);
    }

    /*
     * WARNING - void declaration
     */
    public static String trimRightWith(String string, char ... cArray) {
        void charsToRemove;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(cArray, "charsToRemove must not be null");
        return StringUtils.trimRightWith(string2, StringUtils.charPredicateOf((char[])charsToRemove));
    }

    /*
     * WARNING - void declaration
     */
    public static String trimRightWith(String string, CharSequence charSequence) {
        void charsToRemove;
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        Objects.requireNonNull(charSequence, "charsToRemove must not be null");
        return StringUtils.trimRightWith(string2, StringUtils.charPredicateOf((CharSequence)charsToRemove));
    }

    public static String trimRight(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringUtils.trimRightWith(string2, Character::isWhitespace);
    }

    private static int calculateTrimmedStartPos(String string, CharPredicate charPredicate) {
        char ch;
        int startPos;
        for (startPos = 0; startPos < string.length() && charPredicate.test(ch = string.charAt(startPos)); ++startPos) {
        }
        return startPos;
    }

    private static int calculateTrimmedEndPos(String string, CharPredicate charPredicate) {
        char ch;
        int endPos;
        for (endPos = string.length() - 1; 0 <= endPos && charPredicate.test(ch = string.charAt(endPos)); --endPos) {
        }
        return endPos;
    }

    private static CharPredicate charPredicateOf(char ... charsToRemove) {
        if (charsToRemove.length == 0) {
            return ALWAYS_FALSE_CHAR_PREDICATE;
        }
        return ch -> {
            for (char charToRemove : charsToRemove) {
                if (ch != charToRemove) continue;
                return true;
            }
            return false;
        };
    }

    private static CharPredicate charPredicateOf(CharSequence charsToRemove) {
        if (charsToRemove.length() == 0) {
            return ALWAYS_FALSE_CHAR_PREDICATE;
        }
        return ch -> {
            for (int i = 0; i < charsToRemove.length(); ++i) {
                char charToRemove = charsToRemove.charAt(i);
                if (ch != charToRemove) continue;
                return true;
            }
            return false;
        };
    }

    public static String escapeJava(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringEscapeUtils.escapeJava(string2);
    }

    public static String escapeGroovy(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringUtils.escapeJava(string2).replace("$", "\\$");
    }

    public static String escapeKotlin(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringUtils.escapeJava(string2).replace("$", "\\$");
    }

    public static String escapeJavaScript(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringEscapeUtils.escapeEcmaScript(string2);
    }

    public static String escapeRegex(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringUtils.escapeJavaScript(string2).replace(".", "\\.").replace("|", "\\|").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)").replace("?", "\\?").replace("*", "\\*").replace("+", "\\+").replace("{", "\\{").replace("}", "\\}").replace("^", "\\^").replace("$", "\\$");
    }

    public static String escapeJson(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringEscapeUtils.escapeJson(string2);
    }

    public static String escapeHtml(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringEscapeUtils.escapeHtml4(string2);
    }

    public static String escapeXml(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringEscapeUtils.escapeXml10(string2);
    }

    public static String escapeCsv(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return StringEscapeUtils.escapeCsv(string2);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private StringUtils() {
    }

    @FunctionalInterface
    @ApiStatus.Internal
    @name.remal.gradle_plugins.dsl.internal.Generated
    @RelocatedClass
    @SuppressFBWarnings
    public static interface CharPredicate {
        public boolean test(char var1) throws Throwable;
    }
}

