/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.ObjectUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.PathUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.annotations.ReliesOnInternalGradleApi;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.MembersFinder;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.ReflectionUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.TypedVoidMethod1;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.TypedVoidMethod2;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskInputs;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class TaskUtils {
    @Nullable
    private static final TypedVoidMethod2<Task, String, Spec> ONLY_IF_WITH_REASON_METHOD = MembersFinder.findMethod(Task.class, "onlyIf", String.class, Spec.class);
    private static final String DEFAULT_NOT_COMPATIBLE_WITH_CONFIGURATION_CACHE_REASON = "Not yet compatible with Configuration Cache";
    private static final String REGISTERED_FILE_PROPERTIES_FIELD_NAME = "registeredFileProperties";

    /*
     * WARNING - void declaration
     */
    public static <T extends Task> void onlyIfWithReason(T t, String string, Spec<? super T> spec) {
        void spec2;
        T task;
        Objects.requireNonNull(t, "task must not be null");
        Objects.requireNonNull(string, "reason must not be null");
        Objects.requireNonNull(spec, "spec must not be null");
        if (ONLY_IF_WITH_REASON_METHOD != null) {
            void reason;
            ONLY_IF_WITH_REASON_METHOD.invoke(task, (String)reason, (Spec)spec2);
        } else {
            void typedSpec = spec2;
            task.onlyIf((Spec)typedSpec);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Task> void doBeforeTaskExecution(T t, Action<? super T> action) {
        void action2;
        T task;
        Objects.requireNonNull(t, "task must not be null");
        Objects.requireNonNull(action, "action must not be null");
        TaskUtils.onlyIfWithReason(task, "Before task execution", arg_0 -> TaskUtils.lambda$doBeforeTaskExecution$0((Action)action2, arg_0));
    }

    public static void markAsNotCompatibleWithConfigurationCache(Task task) {
        Task task2;
        Objects.requireNonNull(task, "task must not be null");
        TaskUtils.markAsNotCompatibleWithConfigurationCache(task2, DEFAULT_NOT_COMPATIBLE_WITH_CONFIGURATION_CACHE_REASON);
    }

    @ReliesOnInternalGradleApi
    public static void markAsNotCompatibleWithConfigurationCache(Task task, String string) {
        Task task2;
        Class<?> taskType;
        TypedVoidMethod1<?, String> notCompatibleWithConfigurationCacheMethod;
        String reason;
        Objects.requireNonNull(task, "task must not be null");
        Objects.requireNonNull(string, "reason must not be null");
        if (ObjectUtils.isEmpty(reason)) {
            reason = DEFAULT_NOT_COMPATIBLE_WITH_CONFIGURATION_CACHE_REASON;
        }
        if ((notCompatibleWithConfigurationCacheMethod = MembersFinder.findMethod(taskType = task2.getClass(), "notCompatibleWithConfigurationCache", String.class)) != null) {
            notCompatibleWithConfigurationCacheMethod.invoke(task2, reason);
        }
    }

    public static boolean isInTaskGraph(Task task) {
        Task task2;
        Objects.requireNonNull(task, "task must not be null");
        return task2.getProject().getGradle().getTaskGraph().hasTask(task2);
    }

    public static boolean isRequested(Task task) {
        Path projectPath;
        Task task2;
        Objects.requireNonNull(task, "task must not be null");
        Project project = task2.getProject();
        StartParameter startParameter = project.getGradle().getStartParameter();
        Path requestedProjectPath = Optional.ofNullable(startParameter.getProjectDir()).map(File::toPath).map(PathUtils::normalizePath).orElse(null);
        if (requestedProjectPath != null && !(projectPath = PathUtils.normalizePath(project.getProjectDir().toPath())).startsWith(requestedProjectPath)) {
            return false;
        }
        return startParameter.getTaskNames().stream().anyMatch(task2.getName()::equals);
    }

    public static void disableTask(Task task) {
        Task task2;
        Objects.requireNonNull(task, "task must not be null");
        task2.setEnabled(false);
        task2.onlyIf(__ -> false);
        task2.setDependsOn(Collections.emptyList());
        TaskUtils.clearRegisteredFileProperties(task2.getInputs(), false);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @ReliesOnInternalGradleApi
    static void clearRegisteredFileProperties(TaskInputs taskInputs, boolean bl) {
        void strict;
        Class<?> taskInputsType;
        Objects.requireNonNull(taskInputs, "taskInputs must not be null");
        for (taskInputsType = ReflectionUtils.unwrapGeneratedSubclass(taskInputs2.getClass()); taskInputsType != Object.class; taskInputsType = taskInputsType.getSuperclass()) {
            try {
                Field field = taskInputsType.getDeclaredField(REGISTERED_FILE_PROPERTIES_FIELD_NAME);
                if (!Modifier.isStatic(field.getModifiers()) && Iterable.class.isAssignableFrom(field.getType())) {
                    TaskInputs taskInputs2;
                    Iterable properties = (Iterable)ReflectionUtils.makeAccessible(field).get(taskInputs2);
                    Iterator iterator = properties.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                    return;
                }
                if (strict == false) continue;
                throw new IllegalStateException(String.format("Unsupported field '%s' of %s", REGISTERED_FILE_PROPERTIES_FIELD_NAME, taskInputsType));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (strict != false) {
            throw new IllegalStateException(String.format("Field '%s' can't be found for %s", REGISTERED_FILE_PROPERTIES_FIELD_NAME, taskInputsType));
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private TaskUtils() {
    }

    private static /* synthetic */ boolean lambda$doBeforeTaskExecution$0(Action action, Task currentTask) {
        action.execute((Object)currentTask);
        return true;
    }
}

