/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import lombok.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.InputOutputStreamUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.UriUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.com.google.common.io.ByteStreams;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@name.remal.gradle_plugins.dsl.internal.Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class UrlUtils {
    public static URL parseUrl(String string) {
        String string2;
        Objects.requireNonNull(string, "string must not be null");
        return new URL(string2);
    }

    public static URL toUrl(URI uRI) {
        URI uri;
        Objects.requireNonNull(uRI, "uri must not be null");
        return uri.toURL();
    }

    public static URL toUrl(File file) {
        File file2;
        Objects.requireNonNull(file, "file must not be null");
        return UrlUtils.toUrl(UriUtils.toUri(file2));
    }

    public static URL toUrl(Path path) {
        Path path2;
        Objects.requireNonNull(path, "path must not be null");
        return UrlUtils.toUrl(UriUtils.toUri(path2));
    }

    @MustBeClosed
    public static InputStream openInputStreamForUrl(URL uRL) {
        URL url;
        Objects.requireNonNull(uRL, "url must not be null");
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(60000);
        return InputOutputStreamUtils.withOnClose(connection.getInputStream(), __ -> {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
            if (connection instanceof AutoCloseable) {
                ((AutoCloseable)((Object)connection)).close();
            }
        });
    }

    public static byte[] readBytesFromUrl(URL uRL) {
        byte[] byArray;
        block8: {
            URL url;
            Objects.requireNonNull(uRL, "url must not be null");
            InputStream inputStream = UrlUtils.openInputStreamForUrl(url);
            try {
                byArray = ByteStreams.toByteArray(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            inputStream.close();
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public static String readStringFromUrl(URL uRL, Charset charset) {
        void charset2;
        URL url;
        Objects.requireNonNull(uRL, "url must not be null");
        Objects.requireNonNull(charset, "charset must not be null");
        byte[] bytes = UrlUtils.readBytesFromUrl(url);
        return new String(bytes, (Charset)charset2);
    }

    public static String readStringFromUrl(URL uRL) {
        URL url;
        Objects.requireNonNull(uRL, "url must not be null");
        return UrlUtils.readStringFromUrl(url, StandardCharsets.UTF_8);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private UrlUtils() {
    }
}

