/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection;

import com.google.errorprone.annotations.MustBeClosed;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.objectweb.asm.ClassReader;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@name.remal.gradle_plugins.dsl.internal.Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class ModuleNameParser {
    private static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private static final Pattern FILE_NAME_PART = Pattern.compile("^(?:[^!?#]*[/\\\\]+)?([^!?#/\\\\]+)(?:[!?#].*)?$");
    private static final Pattern VERSION_PART = Pattern.compile("-\\d+(\\..*)?$");
    private static final Pattern NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
    private static final Pattern REPEATING_DOTS = Pattern.compile("\\.{2,}");

    @Nullable
    public static String parseModuleName(@Nullable InputStreamSupplier moduleInfoInputStreamSupplier, @Nullable InputStreamSupplier manifestInputStreamSupplier, @Nullable Path jarFilePath) {
        return ModuleNameParser.parseModuleName(moduleInfoInputStreamSupplier, manifestInputStreamSupplier, jarFilePath != null ? jarFilePath.toString() : null);
    }

    @Nullable
    public static String parseModuleName(@Nullable InputStreamSupplier moduleInfoInputStreamSupplier, @Nullable InputStreamSupplier manifestInputStreamSupplier, @Nullable File jarFile) {
        return ModuleNameParser.parseModuleName(moduleInfoInputStreamSupplier, manifestInputStreamSupplier, jarFile != null ? jarFile.getPath() : null);
    }

    @Nullable
    public static String parseModuleName(@Nullable InputStreamSupplier moduleInfoInputStreamSupplier, @Nullable InputStreamSupplier manifestInputStreamSupplier, @Nullable URI uri) {
        return ModuleNameParser.parseModuleName(moduleInfoInputStreamSupplier, manifestInputStreamSupplier, uri != null ? uri.toString() : null);
    }

    @Nullable
    public static String parseModuleName(@Nullable InputStreamSupplier moduleInfoInputStreamSupplier, @Nullable InputStreamSupplier manifestInputStreamSupplier, @Nullable URL url) {
        return ModuleNameParser.parseModuleName(moduleInfoInputStreamSupplier, manifestInputStreamSupplier, url != null ? url.toString() : null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String parseModuleName(@Nullable InputStreamSupplier moduleInfoInputStreamSupplier, @Nullable InputStreamSupplier manifestInputStreamSupplier, @Nullable String jarFilePath) {
        String moduleName;
        InputStream in;
        if (moduleInfoInputStreamSupplier != null) {
            in = moduleInfoInputStreamSupplier.get();
            try {
                if (in != null) {
                    ClassNode classNode = new ClassNode();
                    new ClassReader(in).accept(classNode, 7);
                    moduleName = Optional.ofNullable(classNode.module).map(it -> it.name).orElse(null);
                    if (moduleName != null) {
                        String string = moduleName;
                        return string;
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (manifestInputStreamSupplier != null) {
            in = manifestInputStreamSupplier.get();
            try {
                if (in != null) {
                    Manifest manifest = new Manifest();
                    manifest.read(in);
                    moduleName = Optional.ofNullable(manifest.getMainAttributes()).map(attrs -> attrs.getValue(AUTOMATIC_MODULE_NAME)).orElse(null);
                    if (moduleName != null) {
                        String string = moduleName;
                        return string;
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        if (jarFilePath == null) return null;
        String moduleName2 = ModuleNameParser.getModuleNameForPath(jarFilePath);
        if (moduleName2 == null) return null;
        return moduleName2;
    }

    @Nullable
    private static String getModuleNameForPath(String path) {
        String fileName = FILE_NAME_PART.matcher(path).replaceFirst("$1");
        if (!fileName.endsWith(".jar")) {
            return null;
        }
        String moduleName = fileName;
        moduleName = moduleName.substring(0, moduleName.length() - ".jar".length());
        moduleName = VERSION_PART.matcher(moduleName).replaceFirst("");
        moduleName = ModuleNameParser.cleanModuleName(moduleName);
        return moduleName;
    }

    private static String cleanModuleName(String moduleName) {
        moduleName = NON_ALPHANUM.matcher(moduleName).replaceAll(".");
        if ((moduleName = REPEATING_DOTS.matcher(moduleName).replaceAll(".")).startsWith(".")) {
            moduleName = moduleName.substring(1);
        }
        if (moduleName.endsWith(".")) {
            moduleName = moduleName.substring(0, moduleName.length() - 1);
        }
        return moduleName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ModuleNameParser() {
    }

    @FunctionalInterface
    @ApiStatus.Internal
    @name.remal.gradle_plugins.dsl.internal.Generated
    @RelocatedClass
    @SuppressFBWarnings
    public static interface InputStreamSupplier {
        @Nullable
        @MustBeClosed
        public InputStream get() throws Exception;
    }
}

