/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.meta.When;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.CrossCompileServices;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.DebugUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.ThrowableUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.annotations.ReliesOnInternalGradleApi;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.com.google.common.collect.ImmutableList;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.internal._relocated.org.objectweb.asm.ClassReader;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.DefaultMethodInvoker;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.LatestLtsJdkModules;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.ReflectionUtilsMethods;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.WhoCalledUtils;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@ReliesOnInternalGradleApi
public abstract class ReflectionUtils {
    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private static final Logger logger = Logging.getLogger(ReflectionUtils.class);
    private static final ReflectionUtilsMethods METHODS = CrossCompileServices.loadCrossCompileService(ReflectionUtilsMethods.class);
    @Nullable
    private static final Class<?> RECORD_CLASS = ReflectionUtils.tryLoadClass("java.lang.Record", ClassLoader.getSystemClassLoader());
    private static final Pattern GETTER_NAME = Pattern.compile("^get[^a-z\\p{Ll}].*$");
    private static final Pattern BOOLEAN_GETTER_NAME = Pattern.compile("^is[^a-z\\p{Ll}].*$");
    private static final DefaultMethodInvoker DEFAULT_METHOD_INVOKER = CrossCompileServices.loadCrossCompileService(DefaultMethodInvoker.class);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Class<?> tryLoadClass(String string, @Nullable ClassLoader classLoader) {
        Objects.requireNonNull(string, "name must not be null");
        try {
            void classLoader2;
            String name;
            return Class.forName(name, false, (ClassLoader)classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static Class<?> tryLoadClass(String string) {
        String name;
        Objects.requireNonNull(string, "name must not be null");
        Class<?> callingClass = WhoCalledUtils.getCallingClass(2);
        return ReflectionUtils.tryLoadClass(name, callingClass.getClassLoader());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClassPresent(String string, @Nullable ClassLoader classLoader) {
        void classLoader2;
        String name;
        Objects.requireNonNull(string, "name must not be null");
        return ReflectionUtils.tryLoadClass(name, (ClassLoader)classLoader2) != null;
    }

    public static boolean isClassPresent(String string) {
        String name;
        Objects.requireNonNull(string, "name must not be null");
        Class<?> callingClass = WhoCalledUtils.getCallingClass(2);
        return ReflectionUtils.isClassPresent(name, callingClass.getClassLoader());
    }

    public static boolean isRecord(Class<?> clazz) {
        Class<?> clazz2;
        Objects.requireNonNull(clazz, "clazz must not be null");
        return RECORD_CLASS != null && RECORD_CLASS.isAssignableFrom(clazz2);
    }

    public static boolean isIndependentClass(Class<?> clazz) {
        Class<?> clazz2;
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz2.isAnonymousClass() || clazz2.isLocalClass()) {
            return false;
        }
        if (clazz2.isPrimitive() || clazz2.isArray() || clazz2.isInterface() || clazz2.isAnnotation() || clazz2.isEnum() || ReflectionUtils.isRecord(clazz2)) {
            return true;
        }
        if (clazz2.getEnclosingClass() == null) {
            return true;
        }
        return clazz2.getDeclaringClass() != null && ReflectionUtils.isStatic(clazz2);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> defineClass(ClassLoader classLoader, byte[] byArray) {
        void bytecode;
        Objects.requireNonNull(classLoader, "classLoader must not be null");
        Objects.requireNonNull(byArray, "bytecode must not be null");
        DebugUtils.ifDebugEnabled(() -> ReflectionUtils.lambda$defineClass$0((byte[])bytecode));
        try {
            ClassLoader classLoader2;
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            ReflectionUtils.makeAccessible(defineClassMethod);
            return (Class)defineClassMethod.invoke((Object)classLoader2, null, bytecode, 0, ((void)bytecode).length);
        }
        catch (Throwable exception) {
            String className = new ClassReader((byte[])bytecode).getClassName().replace('/', '.');
            throw new RuntimeException("Class defining error: " + className, ThrowableUtils.unwrapReflectionException(exception));
        }
    }

    public static Iterable<Class<?>> iterateClassHierarchyWithoutInterfaces(final @Nullable Class<?> rootClass) {
        return new Iterable<Class<?>>(){

            @Override
            @Nonnull
            public Iterator<Class<?>> iterator() {
                if (rootClass == null) {
                    return Collections.emptyIterator();
                }
                return new Iterator<Class<?>>(){
                    @Nullable
                    private Class<?> nextClass;
                    {
                        this.nextClass = rootClass;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextClass != null;
                    }

                    @Override
                    public Class<?> next() {
                        Class<?> currentClass = this.nextClass;
                        if (currentClass == null) {
                            throw new NoSuchElementException();
                        }
                        Class<?> superClass = currentClass.getSuperclass();
                        this.nextClass = superClass != null && superClass != currentClass ? superClass : null;
                        return currentClass;
                    }
                };
            }
        };
    }

    public static Stream<Class<?>> streamClassHierarchyWithoutInterfaces(@Nullable Class<?> rootClass) {
        if (rootClass == null) {
            return Stream.empty();
        }
        return StreamSupport.stream(ReflectionUtils.iterateClassHierarchyWithoutInterfaces(rootClass).spliterator(), false);
    }

    public static @Unmodifiable List<Class<?>> getClassHierarchy(Class<?> clazz) {
        Class clazz2;
        Class<?> rootClass;
        Objects.requireNonNull(clazz, "rootClass must not be null");
        LinkedHashSet result = new LinkedHashSet();
        result.add(rootClass);
        ArrayDeque queue = new ArrayDeque();
        queue.addLast(rootClass);
        while ((clazz2 = (Class)queue.pollFirst()) != null) {
            Class superClass = clazz2.getSuperclass();
            if (superClass != null && result.add(superClass)) {
                queue.addLast(superClass);
            }
            for (Class<?> interfaceClass : clazz2.getInterfaces()) {
                if (!result.add(interfaceClass)) continue;
                queue.addLast(interfaceClass);
            }
        }
        return ImmutableList.copyOf(result);
    }

    @ReliesOnInternalGradleApi
    public static <T> Class<T> unwrapGeneratedSubclass(Class<T> clazz) {
        Class<T> type;
        Objects.requireNonNull(clazz, "type must not be null");
        while (GeneratedSubclass.class.isAssignableFrom(type)) {
            type = type.getSuperclass();
        }
        return type;
    }

    public static <T> Class<T> classOf(T t) {
        T object;
        Objects.requireNonNull(t, "object must not be null");
        return ReflectionUtils.unwrapGeneratedSubclass(object.getClass());
    }

    public static String packageNameOf(Class<?> clazz) {
        Class<?> clazz2;
        Objects.requireNonNull(clazz, "clazz must not be null");
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isPrimitive()) {
            return "java.lang";
        }
        String className = clazz2.getName();
        int lastDelimPos = className.lastIndexOf(46);
        return lastDelimPos >= 0 ? className.substring(0, lastDelimPos) : "";
    }

    @Nullable
    public static String moduleNameOf(Class<?> clazz) {
        Class<?> clazz2;
        Objects.requireNonNull(clazz, "clazz must not be null");
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        if (clazz2.isPrimitive()) {
            return "java.base";
        }
        String moduleName = METHODS.moduleNameOf(clazz2);
        if (moduleName != null) {
            return moduleName;
        }
        return ReflectionUtils.moduleNameOfJdkClass(clazz2.getName());
    }

    @Nullable
    public static String moduleNameOfJdkClass(String string) {
        String className;
        Objects.requireNonNull(string, "className must not be null");
        int lastDelimPos = className.lastIndexOf(46);
        if (lastDelimPos >= 0) {
            String packageName = className.substring(0, lastDelimPos);
            return LatestLtsJdkModules.LATEST_LTS_JDK_PACKAGE_MODULES.get(packageName);
        }
        return null;
    }

    public static Class<?> wrapPrimitiveType(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Void.TYPE == type) {
            return Void.class;
        }
        return type;
    }

    public static Class<?> unwrapPrimitiveType(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        if (Boolean.class == type) {
            return Boolean.TYPE;
        }
        if (Character.class == type) {
            return Character.TYPE;
        }
        if (Byte.class == type) {
            return Byte.TYPE;
        }
        if (Short.class == type) {
            return Short.TYPE;
        }
        if (Integer.class == type) {
            return Integer.TYPE;
        }
        if (Long.class == type) {
            return Long.TYPE;
        }
        if (Float.class == type) {
            return Float.TYPE;
        }
        if (Double.class == type) {
            return Double.TYPE;
        }
        if (Void.class == type) {
            return Void.TYPE;
        }
        return type;
    }

    public static boolean isPublic(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return Modifier.isPublic(type.getModifiers());
    }

    public static boolean isPublic(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return Modifier.isPublic(member2.getModifiers());
    }

    public static boolean isProtected(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return Modifier.isProtected(type.getModifiers());
    }

    public static boolean isProtected(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return Modifier.isProtected(member2.getModifiers());
    }

    public static boolean isPackagePrivate(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return ReflectionUtils.isNotPublic(type) && ReflectionUtils.isNotProtected(type) && ReflectionUtils.isNotPrivate(type);
    }

    public static boolean isPackagePrivate(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return ReflectionUtils.isNotPublic(member2) && ReflectionUtils.isNotProtected(member2) && ReflectionUtils.isNotPrivate(member2);
    }

    public static boolean isPrivate(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return Modifier.isPrivate(type.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return Modifier.isPrivate(member2.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        Class<?> clazz2;
        Objects.requireNonNull(clazz, "clazz must not be null");
        return Modifier.isStatic(clazz2.getModifiers());
    }

    public static boolean isStatic(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return Modifier.isStatic(member2.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return Modifier.isAbstract(type.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        return Modifier.isAbstract(method2.getModifiers());
    }

    public static boolean isFinal(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return Modifier.isFinal(type.getModifiers());
    }

    public static boolean isFinal(Method method) {
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        return Modifier.isFinal(method2.getModifiers());
    }

    public static boolean isSynthetic(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return type.isSynthetic();
    }

    public static boolean isSynthetic(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return member2.isSynthetic();
    }

    public static boolean isNotPublic(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return !ReflectionUtils.isPublic(type);
    }

    public static boolean isNotPublic(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return !ReflectionUtils.isPublic(member2);
    }

    public static boolean isNotProtected(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return !ReflectionUtils.isProtected(type);
    }

    public static boolean isNotProtected(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return !ReflectionUtils.isProtected(member2);
    }

    public static boolean isNotPackagePrivate(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return !ReflectionUtils.isPackagePrivate(type);
    }

    public static boolean isNotPackagePrivate(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return !ReflectionUtils.isPackagePrivate(member2);
    }

    public static boolean isNotPrivate(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return !ReflectionUtils.isPrivate(type);
    }

    public static boolean isNotPrivate(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return !ReflectionUtils.isPrivate(member2);
    }

    public static boolean isNotStatic(Class<?> clazz) {
        Class<?> clazz2;
        Objects.requireNonNull(clazz, "clazz must not be null");
        return !ReflectionUtils.isStatic(clazz2);
    }

    public static boolean isNotStatic(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return !ReflectionUtils.isStatic(member2);
    }

    public static boolean isNotAbstract(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return !ReflectionUtils.isAbstract(type);
    }

    public static boolean isNotAbstract(Method method) {
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        return !ReflectionUtils.isAbstract(method2);
    }

    public static boolean isNotFinal(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return !ReflectionUtils.isFinal(type);
    }

    public static boolean isNotFinal(Method method) {
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        return !ReflectionUtils.isFinal(method2);
    }

    public static boolean isNotSynthetic(Class<?> clazz) {
        Class<?> type;
        Objects.requireNonNull(clazz, "type must not be null");
        return !ReflectionUtils.isSynthetic(type);
    }

    public static boolean isNotSynthetic(Member member) {
        Member member2;
        Objects.requireNonNull(member, "member must not be null");
        return !ReflectionUtils.isSynthetic(member2);
    }

    public static boolean isGetter(Method method) {
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        if (ReflectionUtils.isStatic(method2) || ReflectionUtils.isSynthetic(method2)) {
            return false;
        }
        if (method2.getParameterCount() != 0) {
            return false;
        }
        Class<?> returnType = method2.getReturnType();
        if (returnType == Void.TYPE) {
            return false;
        }
        if (ReflectionUtils.isRecord(method2.getDeclaringClass())) {
            return true;
        }
        if (returnType == Boolean.TYPE) {
            return BOOLEAN_GETTER_NAME.matcher(method2.getName()).matches();
        }
        return GETTER_NAME.matcher(method2.getName()).matches();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isGetterOf(Method method, Class<?> clazz) {
        void type;
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        Objects.requireNonNull(clazz, "type must not be null");
        return ReflectionUtils.isGetter(method2) && type.isAssignableFrom(method2.getReturnType());
    }

    public static String getPropertyNameForGetter(Method method) {
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        if (!ReflectionUtils.isGetter(method2)) {
            throw new AssertionError((Object)("Not a getter: " + method2));
        }
        String methodName = method2.getName();
        if (ReflectionUtils.isRecord(method2.getDeclaringClass())) {
            return methodName;
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring("get".length()));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring("is".length()));
        }
        return methodName;
    }

    @Contract(value="_ -> param1")
    public static <T extends AccessibleObject> T makeAccessible(T t) {
        T member;
        Objects.requireNonNull(t, "member must not be null");
        if (!member.isAccessible() && (ReflectionUtils.isNotPublic((Member)((Object)member)) || ReflectionUtils.isNotPublic(((Member)((Object)member)).getDeclaringClass()))) {
            member.setAccessible(true);
        }
        return member;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull(when=When.UNKNOWN)
    public static Object invokeDefaultMethod(Method method, Object object, Object ... objectArray) {
        Method method2;
        Objects.requireNonNull(method, "method must not be null");
        Objects.requireNonNull(object, "target must not be null");
        if (!method2.isDefault()) {
            throw new IllegalArgumentException("Not a default method: " + method2);
        }
        try {
            void target;
            void args;
            if (args == null) {
                return DEFAULT_METHOD_INVOKER.invoke(method2, target, new Object[0]);
            }
            return DEFAULT_METHOD_INVOKER.invoke(method2, target, (Object[])args);
        }
        catch (Throwable e) {
            throw ThrowableUtils.unwrapReflectionException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private ReflectionUtils() {
    }

    private static /* synthetic */ void lambda$defineClass$0(byte[] bytecode) throws Throwable {
        String className = new ClassReader(bytecode).getClassName().replace('/', '.');
        Path tempFile = Files.createTempFile(className + '-', ".class", new FileAttribute[0]);
        Files.write(tempFile, bytecode, new OpenOption[0]);
    }
}

