/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.xml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.util.IndentPrinter;
import groovy.util.Node;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.PathUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.SneakyThrowUtils;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.MembersFinder;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.reflection.MethodsInvoker;
import name.remal.gradle_plugins.jacoco_to_cobertura.internal._relocated.name.remal.gradle_plugins.toolkit.xml.XmlFormat;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class GroovyXmlUtils {
    private static final Class<?> XML_PARSER_CLASS = GroovyXmlUtils.getXmlParserClass();
    private static final Constructor<?> XML_PARSER_CONSTRUCTOR;
    private static final Class<?> XML_NODE_PRINTER_CLASS;
    private static final Constructor<?> XML_NODE_PRINTER_CONSTRUCTOR;

    public static Node parseXmlToGroovyNode(Path path) {
        Node node;
        block8: {
            Path path2;
            Objects.requireNonNull(path, "path must not be null");
            path2 = PathUtils.normalizePath(path2);
            InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
            try {
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setSystemId(path2.toString());
                node = MethodsInvoker.invokeMethod(GroovyXmlUtils.newNonValidatingXmlParser(), Node.class, "parse", InputSource.class, inputSource);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            inputStream.close();
        }
        return node;
    }

    public static Node parseXmlToGroovyNode(File file) {
        File file2;
        Objects.requireNonNull(file, "file must not be null");
        return GroovyXmlUtils.parseXmlToGroovyNode(file2.toPath());
    }

    /*
     * WARNING - void declaration
     */
    public static Node parseXmlToGroovyNode(@Language(value="XML") String string, @Nullable String string2) {
        void systemId;
        String content;
        Objects.requireNonNull(string, "content must not be null");
        InputSource inputSource = new InputSource(new StringReader(content));
        inputSource.setSystemId((String)systemId);
        return MethodsInvoker.invokeMethod(GroovyXmlUtils.newNonValidatingXmlParser(), Node.class, "parse", InputSource.class, inputSource);
    }

    public static Node parseXmlToGroovyNode(@Language(value="XML") String string) {
        String content;
        Objects.requireNonNull(string, "content must not be null");
        return GroovyXmlUtils.parseXmlToGroovyNode(content, null);
    }

    private static Class<?> getXmlParserClass() {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            return Class.forName("groovy.xml.XmlParser", true, GroovyXmlUtils.class.getClassLoader());
        }
        catch (Throwable e) {
            exceptions.add(e);
            try {
                return Class.forName("groovy.util.XmlParser", true, GroovyXmlUtils.class.getClassLoader());
            }
            catch (Throwable e2) {
                exceptions.add(e2);
                IllegalStateException exception = new IllegalStateException("Groovy's XmlParser class can't be found");
                exceptions.forEach(exception::addSuppressed);
                throw exception;
            }
        }
    }

    private static Object newNonValidatingXmlParser() {
        Object xmlParser = XML_PARSER_CONSTRUCTOR.newInstance(false, true, true);
        MembersFinder.getOptionalMethod(xmlParser.getClass(), "setEntityResolver", EntityResolver.class).ifPresent(method -> method.invoke(xmlParser, (publicId, systemId) -> new InputSource(new StringReader(""))));
        return xmlParser;
    }

    @Language(value="XML")
    public static String compactGroovyXmlString(Node node) {
        Node node2;
        Objects.requireNonNull(node, "node must not be null");
        StringWriter stringWriter = new StringWriter();
        IndentPrinter indentPrinter = new IndentPrinter((Writer)stringWriter, "", false, false);
        Object xmlNodePrinter = GroovyXmlUtils.newXmlNodePrinter(indentPrinter);
        MethodsInvoker.invokeMethod(xmlNodePrinter, "print", Node.class, node2);
        return stringWriter.toString();
    }

    @Language(value="XML")
    public static String prettyGroovyXmlString(Node node) {
        Node node2;
        Objects.requireNonNull(node, "node must not be null");
        return GroovyXmlUtils.prettyGroovyXmlString(node2, XmlFormat.DEFAULT_XML_FORMAT);
    }

    /*
     * WARNING - void declaration
     */
    @Language(value="XML")
    public static String prettyGroovyXmlString(Node node, XmlFormat xmlFormat) {
        Node node2;
        void format;
        Objects.requireNonNull(node, "node must not be null");
        Objects.requireNonNull(xmlFormat, "format must not be null");
        StringWriter stringWriter = new StringWriter();
        XmlFormatIndentPrinter indentPrinter = new XmlFormatIndentPrinter(stringWriter, (XmlFormat)format);
        Object xmlNodePrinter = GroovyXmlUtils.newXmlNodePrinter(indentPrinter);
        MethodsInvoker.invokeMethod(xmlNodePrinter, "print", Node.class, node2);
        return stringWriter.toString();
    }

    private static Class<?> getXmlNodePrinterClass() {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        try {
            return Class.forName("groovy.xml.XmlNodePrinter", true, GroovyXmlUtils.class.getClassLoader());
        }
        catch (Throwable e) {
            exceptions.add(e);
            try {
                return Class.forName("groovy.util.XmlNodePrinter", true, GroovyXmlUtils.class.getClassLoader());
            }
            catch (Throwable e2) {
                exceptions.add(e2);
                IllegalStateException exception = new IllegalStateException("Groovy's XmlNodePrinter class can't be found");
                exceptions.forEach(exception::addSuppressed);
                throw exception;
            }
        }
    }

    private static Object newXmlNodePrinter(IndentPrinter indentPrinter) {
        return XML_NODE_PRINTER_CONSTRUCTOR.newInstance(indentPrinter);
    }

    @SuppressFBWarnings(justification="generated code")
    @lombok.Generated
    private GroovyXmlUtils() {
    }

    static {
        try {
            XML_PARSER_CONSTRUCTOR = XML_PARSER_CLASS.getConstructor(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw SneakyThrowUtils.sneakyThrow(e);
        }
        XML_NODE_PRINTER_CLASS = GroovyXmlUtils.getXmlNodePrinterClass();
        try {
            XML_NODE_PRINTER_CONSTRUCTOR = XML_NODE_PRINTER_CLASS.getConstructor(IndentPrinter.class);
        }
        catch (NoSuchMethodException e) {
            throw SneakyThrowUtils.sneakyThrow(e);
        }
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static class XmlFormatIndentPrinter
    extends IndentPrinter {
        protected final Writer writer;
        protected final XmlFormat xmlFormat;

        public XmlFormatIndentPrinter(Writer writer, XmlFormat xmlFormat) {
            super(writer, xmlFormat.getIndent());
            Objects.requireNonNull(writer, "writer must not be null");
            Objects.requireNonNull(xmlFormat, "xmlFormat must not be null");
            this.writer = writer;
            this.xmlFormat = xmlFormat;
        }

        public void println() {
            this.writer.write(this.xmlFormat.getLineSeparator());
        }
    }
}

