/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.Inputs;
import com.typesafe.zinc.Setup;
import com.typesafe.zinc.ZincClient;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import sbt.compiler.CompileFailed;
import sbt_inc.SbtLogger;
import scala_maven_executions.MainHelper;
import xsbti.Logger;
import xsbti.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SbtIncrementalCompiler {
    public static final String SBT_GROUP_ID = "com.typesafe.sbt";
    public static final String COMPILER_INTEGRATION_ARTIFACT_ID = "incremental-compiler";
    public static final String COMPILER_INTERFACE_ARTIFACT_ID = "compiler-interface";
    public static final String COMPILER_INTERFACE_CLASSIFIER = "sources";
    public static final String XSBTI_ARTIFACT_ID = "sbt-interface";
    private Log log;
    private ZincClient zinc;
    private boolean useServer = false;
    private File compilerJar;
    private File libraryJar;
    private List<File> extraJars;
    private Logger logger;
    private Compiler compiler;

    public SbtIncrementalCompiler(boolean useZincServer, int zincPort, String scalaVersion, File libraryJar, File compilerJar, List<File> extraJars, String sbtVersion, File xsbtiJar, File interfaceJar, Log l) throws Exception {
        this.log = l;
        if (useZincServer) {
            this.zinc = new ZincClient(zincPort);
            if (this.zinc.serverAvailable()) {
                l.info((CharSequence)"Using zinc server for incremental compilation");
                this.useServer = true;
                this.compilerJar = compilerJar;
                this.libraryJar = libraryJar;
                this.extraJars = extraJars;
            } else {
                l.warn((CharSequence)("Zinc server is not available at port " + zincPort + " - reverting to normal incremental compile"));
                this.useServer = false;
            }
        }
        if (!this.useServer) {
            l.info((CharSequence)"Using incremental compilation");
            this.logger = new SbtLogger(l);
            Setup setup = Setup.create((File)compilerJar, (File)libraryJar, extraJars, (File)xsbtiJar, (File)interfaceJar, null);
            if (l.isDebugEnabled()) {
                Setup.debug((Setup)setup, (Logger)this.logger);
            }
            this.compiler = Compiler.create((Setup)setup, (Logger)this.logger);
        }
    }

    public void compile(File baseDir, List<String> classpathElements, List<File> sources, File classesDirectory, List<String> scalacOptions, List<String> javacOptions, File cacheFile, Map<File, File> cacheMap, String compileOrder) throws Exception {
        if (this.useServer) {
            this.zincCompile(baseDir, classpathElements, sources, classesDirectory, scalacOptions, javacOptions, cacheFile, cacheMap, compileOrder);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Incremental compiler = " + this.compiler + " [" + Integer.toHexString(this.compiler.hashCode()) + "]"));
            }
            List<File> classpath = this.pathsToFiles(classpathElements);
            Inputs inputs = Inputs.create(classpath, sources, (File)classesDirectory, scalacOptions, javacOptions, (File)cacheFile, cacheMap, (String)compileOrder);
            if (this.log.isDebugEnabled()) {
                Inputs.debug((Inputs)inputs, (Logger)this.logger);
            }
            this.compiler.compile(inputs, this.logger);
        }
    }

    private void zincCompile(File baseDir, List<String> classpathElements, List<File> sources, File classesDirectory, List<String> scalacOptions, List<String> javacOptions, File cacheFile, Map<File, File> cacheMap, String compileOrder) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-log-level");
        arguments.add(this.logLevelToString(this.log));
        arguments.add("-scala-compiler");
        arguments.add(this.compilerJar.getAbsolutePath());
        arguments.add("-scala-library");
        arguments.add(this.libraryJar.getAbsolutePath());
        arguments.add("-scala-extra");
        ArrayList<String> extraPaths = new ArrayList<String>();
        for (File extraJar : this.extraJars) {
            extraPaths.add(extraJar.getAbsolutePath());
        }
        arguments.add(MainHelper.toMultiPath(extraPaths));
        arguments.add("-classpath");
        arguments.add(MainHelper.toMultiPath(classpathElements));
        arguments.add("-d");
        arguments.add(classesDirectory.getAbsolutePath());
        for (String scalacOption : scalacOptions) {
            arguments.add("-S" + scalacOption);
        }
        for (String javacOption : javacOptions) {
            arguments.add("-J" + javacOption);
        }
        arguments.add("-compile-order");
        arguments.add(compileOrder);
        arguments.add("-analysis-cache");
        arguments.add(cacheFile.getAbsolutePath());
        arguments.add("-analysis-map");
        arguments.add(this.cacheMapToString(cacheMap));
        for (File source : sources) {
            arguments.add(source.getAbsolutePath());
        }
        int exitCode = this.zinc.run(arguments, baseDir, (OutputStream)System.out, (OutputStream)System.err);
        if (exitCode != 0) {
            Problem[] problems = null;
            throw new CompileFailed(arguments.toArray(new String[arguments.size()]), "Compile failed via zinc server", problems);
        }
    }

    private List<File> pathsToFiles(List<String> paths) {
        ArrayList<File> files = new ArrayList<File>(paths.size());
        for (String path : paths) {
            files.add(new File(path));
        }
        return files;
    }

    private String logLevelToString(Log l) {
        if (l.isDebugEnabled()) {
            return "debug";
        }
        if (l.isInfoEnabled()) {
            return "info";
        }
        if (l.isWarnEnabled()) {
            return "warn";
        }
        if (l.isErrorEnabled()) {
            return "error";
        }
        return "info";
    }

    private String cacheMapToString(Map<File, File> cacheMap) throws Exception {
        String analysisMap = "";
        boolean addComma = false;
        for (Map.Entry<File, File> entry : cacheMap.entrySet()) {
            if (addComma) {
                analysisMap = analysisMap + ",";
            }
            analysisMap = analysisMap + entry.getKey().getAbsolutePath();
            analysisMap = analysisMap + ":";
            analysisMap = analysisMap + entry.getValue().getAbsolutePath();
            addComma = true;
        }
        return analysisMap;
    }
}

