/*
 * Decompiled with CFR 0.152.
 */
package net_alchim31_maven_yuicompressor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

public class Aggregation {
    public File inputDir;
    public File output;
    public String[] includes;
    public String[] excludes;
    public boolean removeIncluded = false;
    public boolean insertNewLine = false;
    public boolean fixLastSemicolon = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        this.defineInputDir();
        List<File> files = this.getIncludedFiles();
        if (files.size() != 0) {
            this.output = this.output.getCanonicalFile();
            this.output.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(this.output);
            try {
                for (File file : files) {
                    if (file.getCanonicalPath().equals(this.output.getCanonicalPath())) continue;
                    FileInputStream in = new FileInputStream(file);
                    try {
                        IOUtil.copy((InputStream)in, (OutputStream)out);
                        if (this.fixLastSemicolon) {
                            out.write(59);
                        }
                        if (this.insertNewLine) {
                            out.write(10);
                        }
                    }
                    finally {
                        IOUtil.close((InputStream)in);
                        in = null;
                    }
                    if (!this.removeIncluded) continue;
                    file.delete();
                }
            }
            finally {
                IOUtil.close((OutputStream)out);
                out = null;
            }
        }
    }

    private void defineInputDir() throws Exception {
        if (this.inputDir == null) {
            this.inputDir = this.output.getParentFile();
        }
        this.inputDir = this.inputDir.getCanonicalFile();
    }

    private List<File> getIncludedFiles() throws Exception {
        ArrayList<File> back = new ArrayList<File>();
        if (this.includes != null) {
            for (String include : this.includes) {
                this.addInto(include, back);
            }
        }
        return back;
    }

    private void addInto(String include, List<File> includedFiles) throws Exception {
        if (include.indexOf(42) > -1) {
            DirectoryScanner scanner = this.newScanner();
            scanner.setIncludes(new String[]{include});
            scanner.scan();
            Object[] rpaths = scanner.getIncludedFiles();
            Arrays.sort(rpaths);
            for (Object rpath : rpaths) {
                File file = new File(scanner.getBasedir(), (String)rpath);
                if (includedFiles.contains(file)) continue;
                includedFiles.add(file);
            }
        } else {
            File file = new File(include);
            if (!file.isAbsolute()) {
                file = new File(this.inputDir, include);
            }
            if (!includedFiles.contains(file)) {
                includedFiles.add(file);
            }
        }
    }

    private DirectoryScanner newScanner() throws Exception {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.inputDir);
        if (this.excludes != null && this.excludes.length != 0) {
            scanner.setExcludes(this.excludes);
        }
        scanner.addDefaultExcludes();
        return scanner;
    }
}

