/*
 * Decompiled with CFR 0.152.
 */
package net.anthavio.airbrake;

import airbrake.AirbrakeNotice;
import airbrake.AirbrakeNotifier;
import airbrake.Backtrace;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import java.util.LinkedList;
import net.anthavio.airbrake.AirbrakeNoticeBuilderUsingFilteredSystemProperties;

public class AirbrakeLogbackAppender
extends AppenderBase<ILoggingEvent> {
    private final AirbrakeNotifier airbrakeNotifier;
    private String apiKey;
    private String env;
    private Notify notify = Notify.EXCEPTIONS;
    private Backtrace backtraceBuilder = new Backtrace(new LinkedList());

    public AirbrakeLogbackAppender() {
        this.airbrakeNotifier = new AirbrakeNotifier();
    }

    protected AirbrakeLogbackAppender(AirbrakeNotifier airbrakeNotifier) {
        this.airbrakeNotifier = airbrakeNotifier;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public Backtrace getBacktraceBuilder() {
        return this.backtraceBuilder;
    }

    public void setBacktraceBuilder(Backtrace backtraceBuilder) {
        this.backtraceBuilder = backtraceBuilder;
    }

    public void setUrl(String url) {
        if (url == null || !url.startsWith("http")) {
            throw new IllegalArgumentException("Wrong url: " + url);
        }
        this.airbrakeNotifier.setUrl(url);
    }

    public Notify getNotify() {
        return this.notify;
    }

    public void setNotify(Notify notify) {
        this.notify = notify;
    }

    public void setEnabled(boolean enabled) {
        this.notify = enabled ? Notify.EXCEPTIONS : Notify.OFF;
    }

    protected void append(ILoggingEvent event) {
        if (this.notify == Notify.OFF) {
            return;
        }
        IThrowableProxy proxy = event.getThrowableProxy();
        if (proxy != null) {
            Throwable throwable = ((ThrowableProxy)proxy).getThrowable();
            AirbrakeNotice notice = new AirbrakeNoticeBuilderUsingFilteredSystemProperties(this.apiKey, this.backtraceBuilder, throwable, this.env).newNotice();
            this.airbrakeNotifier.notify(notice);
        } else if (this.notify == Notify.ALL) {
            StackTraceElement[] stackTrace = event.getCallerData();
            AirbrakeNotice notice = new AirbrakeNoticeBuilderUsingFilteredSystemProperties(this.apiKey, event.getFormattedMessage(), stackTrace[0], this.env).newNotice();
            this.airbrakeNotifier.notify(notice);
        }
    }

    public void stop() {
        super.stop();
    }

    public void start() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            this.addError("API key not set for the appender named [" + this.name + "].");
        }
        if (this.env == null || this.env.isEmpty()) {
            this.addError("Environment not set for the appender named [" + this.name + "].");
        }
        super.start();
    }

    public static enum Notify {
        ALL,
        EXCEPTIONS,
        OFF;

    }
}

