/*
 ========================================================================
 Bootstrap: tooltip.js v3.3.7
 http://getbootstrap.com/javascript/#tooltip
 Inspired by the original jQuery.tipsy by Jason Frame
 ========================================================================
 Copyright 2011-2016 Twitter, Inc.
 Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 ======================================================================== */
+function(f){var d=function(b,a){this.inState=this.$element=this.hoverState=this.timeout=this.enabled=this.options=this.type=null;this.init("tooltip",b,a)};d.VERSION="3.3.7";d.TRANSITION_DURATION=150;d.DEFAULTS={animation:!0,placement:"top",selector:!1,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,container:!1,viewport:{selector:"body",padding:0}};d.prototype.init=function(b,a,
c){this.enabled=!0;this.type=b;this.$element=f(a);this.options=this.getOptions(c);this.$viewport=this.options.viewport&&f(f.isFunction(this.options.viewport)?this.options.viewport.call(this,this.$element):this.options.viewport.selector||this.options.viewport);this.inState={click:!1,hover:!1,focus:!1};if(this.$element[0]instanceof document.constructor&&!this.options.selector)throw Error("`selector` option must be specified when initializing "+this.type+" on the window.document object!");b=this.options.trigger.split(" ");
for(a=b.length;a--;)if(c=b[a],"click"==c)this.$element.on("click."+this.type,this.options.selector,f.proxy(this.toggle,this));else if("manual"!=c){var e="hover"==c?"mouseleave":"focusout";this.$element.on(("hover"==c?"mouseenter":"focusin")+"."+this.type,this.options.selector,f.proxy(this.enter,this));this.$element.on(e+"."+this.type,this.options.selector,f.proxy(this.leave,this))}this.options.selector?this._options=f.extend({},this.options,{trigger:"manual",selector:""}):this.fixTitle()};d.prototype.getDefaults=
function(){return d.DEFAULTS};d.prototype.getOptions=function(b){b=f.extend({},this.getDefaults(),this.$element.data(),b);b.delay&&"number"==typeof b.delay&&(b.delay={show:b.delay,hide:b.delay});return b};d.prototype.getDelegateOptions=function(){var b={},a=this.getDefaults();this._options&&f.each(this._options,function(c,e){a[c]!=e&&(b[c]=e)});return b};d.prototype.enter=function(b){var a=b instanceof this.constructor?b:f(b.currentTarget).data("bs."+this.type);a||(a=new this.constructor(b.currentTarget,
this.getDelegateOptions()),f(b.currentTarget).data("bs."+this.type,a));b instanceof f.Event&&(a.inState["focusin"==b.type?"focus":"hover"]=!0);if(a.tip().hasClass("in")||"in"==a.hoverState)a.hoverState="in";else{clearTimeout(a.timeout);a.hoverState="in";if(!a.options.delay||!a.options.delay.show)return a.show();a.timeout=setTimeout(function(){"in"==a.hoverState&&a.show()},a.options.delay.show)}};d.prototype.isInStateTrue=function(){for(var b in this.inState)if(this.inState[b])return!0;return!1};d.prototype.leave=
function(b){var a=b instanceof this.constructor?b:f(b.currentTarget).data("bs."+this.type);a||(a=new this.constructor(b.currentTarget,this.getDelegateOptions()),f(b.currentTarget).data("bs."+this.type,a));b instanceof f.Event&&(a.inState["focusout"==b.type?"focus":"hover"]=!1);if(!a.isInStateTrue()){clearTimeout(a.timeout);a.hoverState="out";if(!a.options.delay||!a.options.delay.hide)return a.hide();a.timeout=setTimeout(function(){"out"==a.hoverState&&a.hide()},a.options.delay.hide)}};d.prototype.show=
function(){var b=f.Event("show.bs."+this.type);if(this.hasContent()&&this.enabled){this.$element.trigger(b);var a=f.contains(this.$element[0].ownerDocument.documentElement,this.$element[0]);if(!b.isDefaultPrevented()&&a){var c=this,b=this.tip(),a=this.getUID(this.type);this.setContent();b.attr("id",a);this.$element.attr("aria-describedby",a);this.options.animation&&b.addClass("fade");var a="function"==typeof this.options.placement?this.options.placement.call(this,b[0],this.$element[0]):this.options.placement,
e=/\s?auto?\s?/i,l=e.test(a);l&&(a=a.replace(e,"")||"top");b.detach().css({top:0,left:0,display:"block"}).addClass(a).data("bs."+this.type,this);this.options.container?b.appendTo(this.options.container):b.insertAfter(this.$element);this.$element.trigger("inserted.bs."+this.type);var e=this.getPosition(),h=b[0].offsetWidth,g=b[0].offsetHeight;if(l){var l=a,k=this.getPosition(this.$viewport),a="bottom"==a&&e.bottom+g>k.bottom?"top":"top"==a&&e.top-g<k.top?"bottom":"right"==a&&e.right+h>k.width?"left":
"left"==a&&e.left-h<k.left?"right":a;b.removeClass(l).addClass(a)}e=this.getCalculatedOffset(a,e,h,g);this.applyPlacement(e,a);a=function(){var a=c.hoverState;c.$element.trigger("shown.bs."+c.type);c.hoverState=null;"out"==a&&c.leave(c)};f.support.transition&&this.$tip.hasClass("fade")?b.one("bsTransitionEnd",a).emulateTransitionEnd(d.TRANSITION_DURATION):a()}}};d.prototype.applyPlacement=function(b,a){var c=this.tip(),e=c[0].offsetWidth,d=c[0].offsetHeight,h=parseInt(c.css("margin-top"),10),g=parseInt(c.css("margin-left"),
10);isNaN(h)&&(h=0);isNaN(g)&&(g=0);b.top+=h;b.left+=g;f.offset.setOffset(c[0],f.extend({using:function(a){c.css({top:Math.round(a.top),left:Math.round(a.left)})}},b),0);c.addClass("in");h=c[0].offsetWidth;g=c[0].offsetHeight;"top"==a&&g!=d&&(b.top=b.top+d-g);var k=this.getViewportAdjustedDelta(a,b,h,g);k.left?b.left+=k.left:b.top+=k.top;e=(a=/top|bottom/.test(a))?2*k.left-e+h:2*k.top-d+g;d=a?"offsetWidth":"offsetHeight";c.offset(b);this.replaceArrow(e,c[0][d],a)};d.prototype.replaceArrow=function(b,
a,c){this.arrow().css(c?"left":"top",50*(1-b/a)+"%").css(c?"top":"left","")};d.prototype.setContent=function(){var b=this.tip(),a=this.getTitle();b.find(".tooltip-inner")[this.options.html?"html":"text"](a);b.removeClass("fade in top bottom left right")};d.prototype.hide=function(b){function a(){"in"!=c.hoverState&&e.detach();c.$element&&c.$element.removeAttr("aria-describedby").trigger("hidden.bs."+c.type);b&&b()}var c=this,e=f(this.$tip),l=f.Event("hide.bs."+this.type);this.$element.trigger(l);
if(!l.isDefaultPrevented())return e.removeClass("in"),f.support.transition&&e.hasClass("fade")?e.one("bsTransitionEnd",a).emulateTransitionEnd(d.TRANSITION_DURATION):a(),this.hoverState=null,this};d.prototype.fixTitle=function(){var b=this.$element;(b.attr("title")||"string"!=typeof b.attr("data-original-title"))&&b.attr("data-original-title",b.attr("title")||"").attr("title","")};d.prototype.hasContent=function(){return this.getTitle()};d.prototype.getPosition=function(b){b=b||this.$element;var a=
b[0],c="BODY"==a.tagName,e=a.getBoundingClientRect();null==e.width&&(e=f.extend({},e,{width:e.right-e.left,height:e.bottom-e.top}));a=window.SVGElement&&a instanceof window.SVGElement;a=c?{top:0,left:0}:a?null:b.offset();b={scroll:c?document.documentElement.scrollTop||document.body.scrollTop:b.scrollTop()};c=c?{width:f(window).width(),height:f(window).height()}:null;return f.extend({},e,b,c,a)};d.prototype.getCalculatedOffset=function(b,a,c,e){return"bottom"==b?{top:a.top+a.height,left:a.left+a.width/
2-c/2}:"top"==b?{top:a.top-e,left:a.left+a.width/2-c/2}:"left"==b?{top:a.top+a.height/2-e/2,left:a.left-c}:{top:a.top+a.height/2-e/2,left:a.left+a.width}};d.prototype.getViewportAdjustedDelta=function(b,a,c,e){var d={top:0,left:0};if(!this.$viewport)return d;var f=this.options.viewport&&this.options.viewport.padding||0,g=this.getPosition(this.$viewport);/right|left/.test(b)?(c=a.top-f-g.scroll,a=a.top+f-g.scroll+e,c<g.top?d.top=g.top-c:a>g.top+g.height&&(d.top=g.top+g.height-a)):(e=a.left-f,a=a.left+
f+c,e<g.left?d.left=g.left-e:a>g.right&&(d.left=g.left+g.width-a));return d};d.prototype.getTitle=function(){var b=this.$element,a=this.options;return b.attr("data-original-title")||("function"==typeof a.title?a.title.call(b[0]):a.title)};d.prototype.getUID=function(b){do b+=~~(1E6*Math.random());while(document.getElementById(b));return b};d.prototype.tip=function(){if(!this.$tip&&(this.$tip=f(this.options.template),1!=this.$tip.length))throw Error(this.type+" `template` option must consist of exactly 1 top-level element!");
return this.$tip};d.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(".tooltip-arrow")};d.prototype.enable=function(){this.enabled=!0};d.prototype.disable=function(){this.enabled=!1};d.prototype.toggleEnabled=function(){this.enabled=!this.enabled};d.prototype.toggle=function(b){var a=this;b&&(a=f(b.currentTarget).data("bs."+this.type),a||(a=new this.constructor(b.currentTarget,this.getDelegateOptions()),f(b.currentTarget).data("bs."+this.type,a)));b?(a.inState.click=!a.inState.click,
a.isInStateTrue()?a.enter(a):a.leave(a)):a.tip().hasClass("in")?a.leave(a):a.enter(a)};d.prototype.destroy=function(){var b=this;clearTimeout(this.timeout);this.hide(function(){b.$element.off("."+b.type).removeData("bs."+b.type);b.$tip&&b.$tip.detach();b.$tip=null;b.$arrow=null;b.$viewport=null;b.$element=null})};var m=f.fn.tooltip;f.fn.tooltip=function(b){return this.each(function(){var a=f(this),c=a.data("bs.tooltip"),e="object"==typeof b&&b;if(c||!/destroy|hide/.test(b))if(c||a.data("bs.tooltip",
c=new d(this,e)),"string"==typeof b)c[b]()})};f.fn.tooltip.Constructor=d;f.fn.tooltip.noConflict=function(){f.fn.tooltip=m;return this}}(jQuery);