/**
 *  Copyright 2014-2017 Riccardo Massera (TheCoder4.Eu).
 *
 *  This file is part of BootsFaces.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.bootsfaces.component.kebab;

import java.io.IOException;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

import net.bootsfaces.render.CoreRenderer;

/** This class generates the HTML code of &lt;b:kebab /&gt;. */
@FacesRenderer(componentFamily = "net.bootsfaces.component", rendererType = "net.bootsfaces.component.kebab.Kebab")
public class KebabRenderer extends CoreRenderer {

	/**
	 * This methods generates the HTML code of the current b:kebab.
	 * <code>encodeBegin</code> generates the start of the component. After the, the JSF framework calls <code>encodeChildren()</code>
	 * to generate the HTML code between the beginning and the end of the component. For instance, in the case of a panel component
	 * the content of the panel is generated by <code>encodeChildren()</code>. After that, <code>encodeEnd()</code> is called
	 * to generate the rest of the HTML code.
	 * @param context the FacesContext.
	 * @param component the current b:kebab.
	 * @throws IOException thrown if something goes wrong when writing the HTML code.
	 */
	/*
	 * <div class="dropdown dropdown-kebab dropdown-kebab-pf">
        <button class="btn btn-link dropdown-toggle" type="button" id="dropdownKebab" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
          <span class="fa fa-ellipsis-v"></span>
        </button>
        <ul class="dropdown-menu " aria-labelledby="dropdownKebab">
          <li><a href="#">Action</a></li>
          <li><a href="#">Another action</a></li>
          <li><a href="#">Something else here</a></li>
          <li role="separator" class="divider"></li>
          <li><a href="#">Separated link</a></li>
        </ul>
      </div>
	 */
	@Override
	public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
	    if (!component.isRendered()) {
	        return;
	    }
		Kebab kebab = (Kebab) component;
		ResponseWriter rw = context.getResponseWriter();
		String clientId = kebab.getClientId();
	
		// Kebabs are a restyled version of a dropdown and support the same feature set.
		// They look like a very tight burger menu.
		
		//<div class="dropdown dropdown-kebab dropdown-kebab-pf">
		rw.startElement("div", kebab);
		rw.writeAttribute("id", kebab.getId(), "id");
	    String s="dropdown dropdown-kebab dropdown-kebab-bf dropdown-kebab-pf";
	    if(kebab.getStyleClass()!=null){
	    	s=s.concat(" ").concat(kebab.getStyleClass());
	    }
	    rw.writeAttribute("class", s, "class");
		
	    if(kebab.getStyle()!=null){
	    	rw.writeAttribute("style", kebab.getStyle(), "style");
	    }
	    
	    //Button
	    //<button id="dropdownKebab" class="btn btn-link dropdown-toggle" type="button" data-toggle="dropdown" 
	    //aria-haspopup="true" aria-expanded="true">
	    rw.startElement("button", kebab);
	    rw.writeAttribute("id", kebab.getId()+"_btn", "id");
	    rw.writeAttribute("class", "btn btn-link dropdown-toggle", "class");
	    rw.writeAttribute("type", "button", "type");
	    rw.writeAttribute("data-toggle", "dropdown", "data-toggle");
	    //ARIA Attributes
	    rw.writeAttribute("aria-haspopup", "true", "aria-haspopup");
	    rw.writeAttribute("aria-expanded", "true", "aria-expanded");
	    
	    //<span class="fa fa-ellipsis-v"></span>
	    rw.startElement("span", kebab);
	    rw.writeAttribute("class", "fa fa-ellipsis-v", "class");
	    rw.endElement("span");
	    rw.endElement("button");
	    
	    //<ul class="dropdown-menu " aria-labelledby="dropdownKebab">
	    rw.startElement("ul", kebab);
	    rw.writeAttribute("class", "dropdown-menu ", "class");
	    rw.writeAttribute("aria-labelledby", kebab.getId()+"_btn", "aria-labelledby");
	    
		//rw.writeText("Dummy content of b:kebab", null);
	
	}

	/**
	 * This methods generates the HTML code of the current b:kebab.
	 * <code>encodeBegin</code> generates the start of the component. After the, the JSF framework calls <code>encodeChildren()</code>
	 * to generate the HTML code between the beginning and the end of the component. For instance, in the case of a panel component
	 * the content of the panel is generated by <code>encodeChildren()</code>. After that, <code>encodeEnd()</code> is called
	 * to generate the rest of the HTML code.
	 * @param context the FacesContext.
	 * @param component the current b:kebab.
	 * @throws IOException thrown if something goes wrong when writing the HTML code.
	 */
	@Override
	public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
		if (!component.isRendered()) {
			return;
		}
		Kebab kebab = (Kebab) component;
		ResponseWriter rw = context.getResponseWriter();
		rw.endElement("ul");
		rw.endElement("div");
		
	}

}
