/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JdbcWrapperHelper {
    private JdbcWrapperHelper() {
    }

    static Map<String, DataSource> getDataSources() throws NamingException {
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>(2);
        String datasourcesParameter = Parameters.getParameter(Parameter.DATASOURCES);
        if (datasourcesParameter == null) {
            dataSources.putAll(JdbcWrapperHelper.getDataSourcesAt("java:comp/env/jdbc"));
            dataSources.putAll(JdbcWrapperHelper.getDataSourcesAt("java:/jdbc"));
        } else if (datasourcesParameter.trim().length() != 0) {
            for (String datasource : datasourcesParameter.split(",")) {
                String jndiName = datasource.trim();
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(jndiName);
                dataSources.put(jndiName, dataSource);
            }
        }
        return Collections.unmodifiableMap(dataSources);
    }

    private static Map<String, DataSource> getDataSourcesAt(String jndiPrefix) throws NamingException {
        InitialContext initialContext = new InitialContext();
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>(2);
        try {
            for (NameClassPair nameClassPair : Collections.list(initialContext.list(jndiPrefix))) {
                String jndiName = nameClassPair.getName().startsWith("java:") ? nameClassPair.getName() : jndiPrefix + '/' + nameClassPair.getName();
                Object value = initialContext.lookup(jndiName);
                if (!(value instanceof DataSource)) continue;
                dataSources.put(jndiName, (DataSource)value);
            }
        }
        catch (NameNotFoundException e) {
            return dataSources;
        }
        return dataSources;
    }

    static Object changeContextWritable(ServletContext servletContext, Object securityToken) throws NoSuchFieldException, ClassNotFoundException, IllegalAccessException, NamingException {
        assert (servletContext != null);
        if (servletContext.getServerInfo().contains("Tomcat") && System.getProperty("jonas.name") == null) {
            Field field = Class.forName("org.apache.naming.ContextAccessController").getDeclaredField("readOnlyContexts");
            JdbcWrapperHelper.setFieldAccessible(field);
            Hashtable readOnlyContexts = (Hashtable)field.get(null);
            String contextName = "/Catalina/localhost" + Parameters.getContextPath(servletContext);
            if (securityToken == null) {
                return readOnlyContexts.remove(contextName);
            }
            readOnlyContexts.put(contextName, securityToken);
            return null;
        }
        if (servletContext.getServerInfo().contains("jetty")) {
            Context jdbcContext = (Context)new InitialContext().lookup("java:comp");
            Field field = JdbcWrapperHelper.getAccessibleField(jdbcContext, "_env");
            Hashtable env = (Hashtable)field.get(jdbcContext);
            if (securityToken == null) {
                return env.remove("org.mortbay.jndi.lock");
            }
            env.put("org.mortbay.jndi.lock", securityToken);
            return null;
        }
        return null;
    }

    static Field getAccessibleField(Object object, String fieldName) {
        assert (fieldName != null);
        Class<?> classe = object.getClass();
        Field result = null;
        do {
            for (Field field : classe.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                result = field;
                break;
            }
            classe = classe.getSuperclass();
        } while (result == null && classe != null);
        assert (result != null);
        JdbcWrapperHelper.setFieldAccessible(result);
        return result;
    }

    private static void setFieldAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }
}

