/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.CompressionServletResponseWrapper;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlCounterReport;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfReport;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.TransportFormat;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MonitoringController {
    private final Collector collector;
    private final CollectorServer collectorServer;
    private String messageForReport;

    MonitoringController(Collector collector, CollectorServer collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    boolean isJavaInformationsNeeded(HttpServletRequest httpRequest) {
        return httpRequest.getParameter("resource") == null && httpRequest.getParameter("graph") == null && httpRequest.getParameter("part") == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String executeActionIfNeeded(HttpServletRequest httpRequest) throws IOException {
        assert (httpRequest != null);
        String actionParameter = httpRequest.getParameter("action");
        if (actionParameter != null) {
            String string;
            try {
                I18N.bindLocale(httpRequest.getLocale());
                Action action = Action.valueOfIgnoreCase(actionParameter);
                if (action != Action.CLEAR_COUNTER) {
                    Action.checkSystemActionsEnabled();
                }
                String counterName = httpRequest.getParameter("counter");
                String sessionId = httpRequest.getParameter("sessionId");
                string = this.messageForReport = action.execute(this.collector, counterName, sessionId);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                I18N.unbindLocale();
                throw throwable;
            }
            I18N.unbindLocale();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doReport(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            assert (httpRequest != null);
                            assert (httpResponse != null);
                            assert (javaInformationsList != null);
                            String resource = httpRequest.getParameter("resource");
                            if (resource != null) {
                                this.doResource(httpResponse, resource);
                                return;
                            }
                            MonitoringController.noCache(httpResponse);
                            try {
                                I18N.bindLocale(httpRequest.getLocale());
                                Period period = MonitoringController.getPeriod(httpRequest);
                                String part = httpRequest.getParameter("part");
                                String graph = httpRequest.getParameter("graph");
                                if (part == null && graph != null) {
                                    this.doGraph(httpRequest, httpResponse, period, graph);
                                    Object var10_8 = null;
                                    break block13;
                                }
                                if ("lastValue".equalsIgnoreCase(part)) {
                                    this.doLastValue(httpResponse, graph);
                                    break block14;
                                }
                                if ("web.xml".equalsIgnoreCase(part)) {
                                    this.doWebXml(httpResponse);
                                    break block15;
                                }
                                if ("pom.xml".equalsIgnoreCase(part)) {
                                    this.doPomXml(httpResponse);
                                    break block16;
                                }
                                String format = httpRequest.getParameter("format");
                                if (format == null || "html".equalsIgnoreCase(format)) {
                                    this.doCompressedHtml(httpRequest, httpResponse, javaInformationsList, period, part);
                                    break block17;
                                }
                                if ("pdf".equalsIgnoreCase(format)) {
                                    this.doPdf(httpRequest, httpResponse, period, javaInformationsList);
                                    break block17;
                                } else {
                                    this.doSerializable(httpRequest, httpResponse, javaInformationsList, format);
                                }
                                break block17;
                            }
                            catch (Throwable throwable) {
                                Object var10_13 = null;
                                I18N.unbindLocale();
                                throw throwable;
                            }
                        }
                        I18N.unbindLocale();
                        return;
                    }
                    Object var10_9 = null;
                    I18N.unbindLocale();
                    return;
                }
                Object var10_10 = null;
                I18N.unbindLocale();
                return;
            }
            Object var10_11 = null;
            I18N.unbindLocale();
            return;
        }
        Object var10_12 = null;
        I18N.unbindLocale();
    }

    static void noCache(HttpServletResponse httpResponse) {
        httpResponse.addHeader("Cache-Control", "no-cache");
        httpResponse.addHeader("Pragma", "no-cache");
        httpResponse.addHeader("Expires", "-1");
    }

    static Period getPeriod(HttpServletRequest req) {
        Period period = req.getParameter("period") == null ? Period.JOUR : Period.valueOfIgnoreCase(req.getParameter("period"));
        return period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList, Period period, String part) throws IOException {
        block3: {
            if (MonitoringController.isCompressionSupported(httpRequest)) {
                CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
                try {
                    this.doHtml(httpRequest, (HttpServletResponse)wrappedResponse, javaInformationsList, period, part);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    wrappedResponse.finishResponse();
                    throw throwable;
                }
                wrappedResponse.finishResponse();
                {
                    break block3;
                }
            }
            this.doHtml(httpRequest, httpResponse, javaInformationsList, period, part);
        }
    }

    private void doSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList, String format) throws IOException {
        TransportFormat transportFormat = TransportFormat.valueOfIgnoreCase(format);
        Serializable serializable = this.createSerializable(httpRequest, javaInformationsList);
        httpResponse.setContentType(transportFormat.getMimeType());
        String fileName = "JavaMelody_" + this.collector.getApplication().replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + '.' + transportFormat.getCode();
        httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
        transportFormat.writeSerializableTo(serializable, (OutputStream)httpResponse.getOutputStream());
        if ("stop".equalsIgnoreCase(httpRequest.getParameter("collector"))) {
            this.collector.stop();
        }
    }

    private Serializable createSerializable(HttpServletRequest httpRequest, List<JavaInformations> javaInformationsList) {
        String part = httpRequest.getParameter("part");
        try {
            if ("heaphisto".equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                return VirtualMachine.createHeapHistogram();
            }
            if ("sessions".equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                String sessionId = httpRequest.getParameter("sessionId");
                if (sessionId == null) {
                    List<SessionInformations> sessionsInformations = SessionListener.getAllSessionsInformations();
                    return (Serializable)((Object)sessionsInformations);
                }
                return SessionListener.getSessionInformationsBySessionId(sessionId);
            }
            if ("processes".equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                return (Serializable)((Object)ProcessInformations.buildProcessInformations());
            }
            if ("database".equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                int requestIndex = httpRequest.getParameter("request") != null ? Integer.parseInt(httpRequest.getParameter("request")) : 0;
                return new DatabaseInformations(requestIndex);
            }
        }
        catch (Exception e) {
            return e;
        }
        List<Counter> counters = this.collector.getCounters();
        ArrayList<Object> serialized = new ArrayList<Object>(counters.size() + javaInformationsList.size());
        for (Counter counter : counters) {
            serialized.add(counter.clone());
        }
        serialized.addAll(javaInformationsList);
        if (this.messageForReport != null) {
            serialized.add(this.messageForReport);
        }
        return serialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList, Period period, String part) throws IOException {
        if (this.collectorServer == null && (part == null || "currentRequests".equalsIgnoreCase(part) || "graph".equalsIgnoreCase(part))) {
            this.collector.collectLocalContextWithoutErrors();
        }
        httpResponse.setContentType("text/html; charset=ISO-8859-1");
        BufferedWriter writer = new BufferedWriter(httpResponse.getWriter());
        try {
            HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, javaInformationsList, period, writer);
            if (part == null) {
                htmlReport.toHtml(this.messageForReport);
            } else {
                this.doHtmlPart(httpRequest, part, htmlReport);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    private void doHtmlPart(HttpServletRequest httpRequest, String part, HtmlReport htmlReport) throws IOException {
        if ("graph".equalsIgnoreCase(part)) {
            String graphName = httpRequest.getParameter("graph");
            htmlReport.writeRequestAndGraphDetail(graphName);
        } else if ("usages".equalsIgnoreCase(part)) {
            String graphName = httpRequest.getParameter("graph");
            htmlReport.writeRequestUsages(graphName);
        } else if ("sessions".equalsIgnoreCase(part)) {
            this.doSessions(httpRequest, htmlReport);
        } else if (this.collectorServer == null && "currentRequests".equalsIgnoreCase(part)) {
            this.doCurrentRequests(htmlReport);
        } else if ("heaphisto".equalsIgnoreCase(part)) {
            this.doHeapHisto(htmlReport);
        } else if ("processes".equalsIgnoreCase(part)) {
            this.doProcesses(htmlReport);
        } else if ("database".equalsIgnoreCase(part)) {
            int requestIndex = httpRequest.getParameter("request") != null ? Integer.parseInt(httpRequest.getParameter("request")) : 0;
            this.doDatabase(htmlReport, requestIndex);
        } else {
            throw new IllegalArgumentException(part);
        }
    }

    private void doSessions(HttpServletRequest httpRequest, HtmlReport htmlReport) throws IOException {
        Action.checkSystemActionsEnabled();
        String sessionId = httpRequest.getParameter("sessionId");
        List<SessionInformations> sessionsInformations = this.collectorServer == null ? (sessionId == null ? SessionListener.getAllSessionsInformations() : Collections.singletonList(SessionListener.getSessionInformationsBySessionId(sessionId))) : this.collectorServer.collectSessionInformations(this.collector.getApplication(), sessionId);
        if (sessionId == null || sessionsInformations.isEmpty()) {
            htmlReport.writeSessions(sessionsInformations, this.messageForReport, "sessions");
        } else {
            SessionInformations sessionInformation = sessionsInformations.get(0);
            htmlReport.writeSessionDetail(sessionId, sessionInformation);
        }
    }

    private void doCurrentRequests(HtmlReport htmlReport) throws IOException {
        assert (this.collectorServer == null);
        htmlReport.writeCurrentRequests(JavaInformations.buildThreadInformationsList(), true, new HashMap<String, HtmlCounterReport>());
    }

    private void doHeapHisto(HtmlReport htmlReport) throws IOException {
        HeapHistogram heapHistogram;
        Action.checkSystemActionsEnabled();
        try {
            heapHistogram = this.collectorServer == null ? VirtualMachine.createHeapHistogram() : this.collectorServer.collectHeapHistogram(this.collector.getApplication());
        }
        catch (Exception e) {
            Collector.printStackTrace(e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
            return;
        }
        htmlReport.writeHeapHistogram(heapHistogram, this.messageForReport, "heaphisto");
    }

    private void doProcesses(HtmlReport htmlReport) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeProcesses(ProcessInformations.buildProcessInformations());
        }
        catch (Exception e) {
            Collector.printStackTrace(e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    private void doDatabase(HtmlReport htmlReport, int requestIndex) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeDatabase(new DatabaseInformations(requestIndex));
        }
        catch (Exception e) {
            Collector.printStackTrace(e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHtmlToLastShutdownFile() {
        try {
            File dir = Parameters.getStorageDirectory(this.collector.getApplication());
            if (!dir.mkdirs() && !dir.exists()) {
                throw new IOException("JavaMelody directory can't be created: " + dir.getPath());
            }
            File lastShutdownFile = new File(dir, "last_shutdown.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(lastShutdownFile));
            try {
                JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
                HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, Collections.singletonList(javaInformations), Period.JOUR, writer);
                htmlReport.toHtml(null);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                writer.close();
                throw throwable;
            }
            writer.close();
            {
            }
        }
        catch (IOException e) {
            Collector.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPdf(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Period period, List<JavaInformations> javaInformationsList) throws IOException {
        if (this.collectorServer == null) {
            this.collector.collectLocalContextWithoutErrors();
        }
        httpResponse.setContentType("application/pdf");
        httpResponse.addHeader("Content-Disposition", MonitoringController.encodeFileNameToContentDisposition(httpRequest, PdfReport.getFileName(this.collector.getApplication())));
        try {
            PdfReport pdfReport = new PdfReport(this.collector, this.collectorServer != null, javaInformationsList, period, (OutputStream)httpResponse.getOutputStream());
            pdfReport.toPdf();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            httpResponse.getOutputStream().flush();
            throw throwable;
        }
        httpResponse.getOutputStream().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResource(HttpServletResponse httpResponse, String resource) throws IOException {
        httpResponse.addHeader("Cache-Control", "max-age=3600");
        ServletOutputStream out = httpResponse.getOutputStream();
        String localResource = Parameters.getResourcePath(resource.replace("..", ""));
        httpResponse.setContentType(Parameters.getServletContext().getMimeType(localResource));
        BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(localResource));
        try {
            TransportFormat.pump(in, (OutputStream)out);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    private void doGraph(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Period period, String graphName) throws IOException {
        int width = Math.min(Integer.parseInt(httpRequest.getParameter("width")), 1600);
        int height = Math.min(Integer.parseInt(httpRequest.getParameter("height")), 1600);
        JRobin jrobin = this.collector.getJRobin(graphName);
        if (jrobin != null) {
            byte[] img = jrobin.graph(period, width, height);
            httpResponse.setContentType("image/png");
            httpResponse.setContentLength(img.length);
            String fileName = graphName + ".png";
            httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
            httpResponse.getOutputStream().write(img);
            httpResponse.flushBuffer();
        }
    }

    private void doLastValue(HttpServletResponse httpResponse, String graphName) throws IOException {
        httpResponse.setContentType("text/plain");
        boolean first = true;
        for (String graph : graphName.split(",")) {
            JRobin jrobin = this.collector.getJRobin(graph);
            double lastValue = jrobin == null ? -1.0 : jrobin.getLastValue();
            if (first) {
                first = false;
            } else {
                httpResponse.getWriter().write(",");
            }
            httpResponse.getWriter().write(String.valueOf(lastValue));
        }
        httpResponse.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWebXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType(Parameters.getServletContext().getMimeType("/WEB-INF/web.xml"));
        httpResponse.addHeader("Content-Disposition", "inline;filename=web.xml");
        InputStream in = MonitoringController.getWebXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPomXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType(Parameters.getServletContext().getMimeType("/WEB-INF/web.xml"));
        httpResponse.addHeader("Content-Disposition", "inline;filename=pom.xml");
        InputStream in = MonitoringController.getPomXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    private static InputStream getWebXmlAsStream() {
        InputStream webXml = Parameters.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
        if (webXml == null) {
            return null;
        }
        return new BufferedInputStream(webXml);
    }

    private static InputStream getPomXmlAsStream() {
        ServletContext servletContext = Parameters.getServletContext();
        Set mavenDir = servletContext.getResourcePaths("/META-INF/maven/");
        if (mavenDir == null || mavenDir.isEmpty()) {
            return null;
        }
        Set groupDir = servletContext.getResourcePaths((String)mavenDir.iterator().next());
        if (groupDir == null || groupDir.isEmpty()) {
            return null;
        }
        InputStream pomXml = servletContext.getResourceAsStream(groupDir.iterator().next() + "pom.xml");
        if (pomXml == null) {
            return null;
        }
        return new BufferedInputStream(pomXml);
    }

    private static String encodeFileNameToContentDisposition(HttpServletRequest httpRequest, String fileName) {
        assert (fileName != null);
        String userAgent = httpRequest.getHeader("user-agent");
        if (userAgent != null && userAgent.contains("MSIE")) {
            return "attachment;filename=" + fileName;
        }
        return MonitoringController.encodeFileNameToStandardContentDisposition(fileName);
    }

    private static String encodeFileNameToStandardContentDisposition(String fileName) {
        int length = fileName.length();
        StringBuilder sb = new StringBuilder(length + length / 4);
        sb.append("attachment;filename*=\"");
        for (int i = 0; i < length; ++i) {
            char c = fileName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('%');
            if (c < '\u0010') {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static boolean isCompressionSupported(HttpServletRequest httpRequest) {
        boolean supportCompression = false;
        ArrayList<String> acceptEncodings = Collections.list(httpRequest.getHeaders("Accept-Encoding"));
        for (String name : acceptEncodings) {
            if (!name.contains("gzip")) continue;
            supportCompression = true;
            break;
        }
        return supportCompression;
    }

    static {
        boolean webXmlExists = false;
        boolean pomXmlExists = false;
        try {
            InputStream pomXmlAsStream;
            InputStream webXmlAsStream = MonitoringController.getWebXmlAsStream();
            if (webXmlAsStream != null) {
                webXmlAsStream.close();
                webXmlExists = true;
            }
            if ((pomXmlAsStream = MonitoringController.getPomXmlAsStream()) != null) {
                pomXmlAsStream.close();
                pomXmlExists = true;
            }
        }
        catch (IOException e) {
            Collector.printStackTrace(e);
        }
        JavaInformations.setWebXmlExistsAndPomXmlExists(webXmlExists, pomXmlExists);
    }
}

