/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.PID;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.SessionListener;
import net.sf.ehcache.CacheManager;
import org.quartz.JobDetail;
import org.quartz.Scheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Action
extends Enum<Action> {
    public static final /* enum */ Action CLEAR_COUNTER = new Action();
    public static final /* enum */ Action GC = new Action();
    public static final /* enum */ Action INVALIDATE_SESSIONS = new Action();
    public static final /* enum */ Action INVALIDATE_SESSION = new Action();
    public static final /* enum */ Action HEAP_DUMP = new Action();
    public static final /* enum */ Action CLEAR_CACHES = new Action();
    public static final /* enum */ Action KILL_THREAD = new Action();
    public static final /* enum */ Action PAUSE_JOB = new Action();
    public static final /* enum */ Action RESUME_JOB = new Action();
    static final boolean GC_ENABLED;
    static final boolean HEAP_DUMP_ENABLED;
    private static final String ALL = "all";
    private static final /* synthetic */ Action[] $VALUES;

    public static Action[] values() {
        return (Action[])$VALUES.clone();
    }

    public static Action valueOf(String name) {
        return Enum.valueOf(Action.class, name);
    }

    static Action valueOfIgnoreCase(String action) {
        return Action.valueOf(action.toUpperCase(Locale.getDefault()).trim());
    }

    static void checkSystemActionsEnabled() {
        if (!Boolean.parseBoolean(Parameters.getParameter(Parameter.SYSTEM_ACTIONS_ENABLED))) {
            throw new IllegalStateException(I18N.getString("Actions_non_activees"));
        }
    }

    String execute(Collector collector, String counterName, String sessionId, String threadId, String jobId) throws IOException {
        String messageForReport;
        switch (this) {
            case CLEAR_COUNTER: {
                assert (collector != null);
                assert (counterName != null);
                messageForReport = this.clearCounter(collector, counterName);
                break;
            }
            case GC: {
                if (GC_ENABLED) {
                    long before = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    this.gc();
                    long after = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                    messageForReport = I18N.getFormattedString("ramasse_miette_execute", (before - after) / 1024L);
                    break;
                }
                messageForReport = I18N.getString("ramasse_miette_desactive");
                break;
            }
            case HEAP_DUMP: {
                if (HEAP_DUMP_ENABLED) {
                    String heapDumpPath = this.heapDump().getPath();
                    messageForReport = I18N.getFormattedString("heap_dump_genere", heapDumpPath.replace('\\', '/'));
                    break;
                }
                messageForReport = I18N.getString("heap_dump_not_good");
                break;
            }
            case INVALIDATE_SESSIONS: {
                SessionListener.invalidateAllSessions();
                messageForReport = I18N.getString("sessions_http_invalidees");
                break;
            }
            case INVALIDATE_SESSION: {
                assert (sessionId != null);
                SessionListener.invalidateSession(sessionId);
                messageForReport = I18N.getString("session_http_invalidee");
                break;
            }
            case CLEAR_CACHES: {
                this.clearCaches();
                messageForReport = I18N.getString("caches_purges");
                break;
            }
            case KILL_THREAD: {
                assert (threadId != null);
                messageForReport = this.killThread(threadId);
                break;
            }
            case PAUSE_JOB: {
                assert (jobId != null);
                messageForReport = this.pauseJob(jobId);
                break;
            }
            case RESUME_JOB: {
                assert (jobId != null);
                messageForReport = this.resumeJob(jobId);
                break;
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
        return messageForReport;
    }

    private String clearCounter(Collector collector, String counterName) {
        String messageForReport;
        if (ALL.equalsIgnoreCase(counterName)) {
            for (Counter counter : collector.getCounters()) {
                collector.clearCounter(counter.getName());
            }
            messageForReport = I18N.getFormattedString("Toutes_statistiques_reinitialisees", counterName);
        } else {
            collector.clearCounter(counterName);
            messageForReport = I18N.getFormattedString("Statistiques_reinitialisees", counterName);
        }
        return messageForReport;
    }

    private File heapDump() throws IOException {
        boolean gcBeforeHeapDump = true;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault());
        File heapDumpFile = new File(Parameters.TEMPORARY_DIRECTORY.getPath(), "heapdump-" + Parameters.getHostName() + '-' + dateFormat.format(new Date()) + ".hprof");
        if (heapDumpFile.exists()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            return this.heapDump();
        }
        try {
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectInstance instance = platformMBeanServer.getObjectInstance(new ObjectName("com.sun.management:type=HotSpotDiagnostic"));
            ((HotSpotDiagnosticMXBean)platformMBeanServer.instantiate(instance.getClassName())).dumpHeap(heapDumpFile.getPath(), true);
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
        return heapDumpFile;
    }

    private void gc() {
        Runtime.getRuntime().gc();
    }

    private void clearCaches() {
        List allCacheManagers = CacheManager.ALL_CACHE_MANAGERS;
        for (CacheManager cacheManager : allCacheManagers) {
            cacheManager.clearAll();
        }
    }

    private String killThread(String threadId) {
        String[] values = threadId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(threadId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            long myThreadId = Long.parseLong(values[2]);
            List<Thread> threads = JavaInformations.getThreadsFromThreadGroups();
            for (Thread thread : threads) {
                if (thread.getId() != myThreadId) continue;
                this.stopThread(thread);
                return I18N.getFormattedString("Thread_tue", thread.getName());
            }
            return I18N.getString("Thread_non_trouve");
        }
        return null;
    }

    private void stopThread(Thread thread) {
        thread.stop();
    }

    private String pauseJob(String jobId) {
        if (ALL.equalsIgnoreCase(jobId)) {
            this.pauseAllJobs();
            return I18N.getString("all_jobs_paused");
        }
        String[] values = jobId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(jobId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            if (this.pauseJobById(Integer.parseInt(values[2]))) {
                return I18N.getString("job_paused");
            }
            return I18N.getString("job_notfound");
        }
        return null;
    }

    private boolean pauseJobById(int myJobId) {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                for (JobDetail jobDetail : JobInformations.getAllJobsOfScheduler(scheduler)) {
                    if (jobDetail.getFullName().hashCode() != myJobId) continue;
                    scheduler.pauseJob(jobDetail.getName(), jobDetail.getGroup());
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void pauseAllJobs() {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                scheduler.pauseAll();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String resumeJob(String jobId) {
        if (ALL.equalsIgnoreCase(jobId)) {
            this.resumeAllJobs();
            return I18N.getString("all_jobs_resumed");
        }
        String[] values = jobId.split("_");
        if (values.length != 3) {
            throw new IllegalArgumentException(jobId);
        }
        if (values[0].equals(PID.getPID()) && values[1].equals(Parameters.getHostAddress())) {
            if (this.resumeJobById(Integer.parseInt(values[2]))) {
                return I18N.getString("job_resumed");
            }
            return I18N.getString("job_notfound");
        }
        return null;
    }

    private boolean resumeJobById(int myJobId) {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                for (JobDetail jobDetail : JobInformations.getAllJobsOfScheduler(scheduler)) {
                    if (jobDetail.getFullName().hashCode() != myJobId) continue;
                    scheduler.resumeJob(jobDetail.getName(), jobDetail.getGroup());
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void resumeAllJobs() {
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                scheduler.resumeAll();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        $VALUES = new Action[]{CLEAR_COUNTER, GC, INVALIDATE_SESSIONS, INVALIDATE_SESSION, HEAP_DUMP, CLEAR_CACHES, KILL_THREAD, PAUSE_JOB, RESUME_JOB};
        GC_ENABLED = !ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-XX:+DisableExplicitGC");
        HEAP_DUMP_ENABLED = "1.6".compareTo(System.getProperty("java.version")) < 0 && System.getProperty("java.vendor").contains("Sun");
    }
}

