/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JdbcDriver;
import net.bull.javamelody.JdbcWrapperHelper;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseInformations
implements Serializable {
    private static final long serialVersionUID = -6105478981257689782L;
    private final Database database;
    private final List<String> requestNames;
    private final int selectedRequestIndex;
    private final String[][] result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseInformations(int selectedRequestIndex) throws SQLException, NamingException {
        this.selectedRequestIndex = selectedRequestIndex;
        Connection connection = DatabaseInformations.getConnection();
        try {
            this.database = Database.getDatabaseForConnection(connection);
            this.requestNames = this.database.getRequestNames();
            String request = this.database.getRequestByName(this.requestNames.get(selectedRequestIndex));
            this.result = DatabaseInformations.executeRequest(connection, request, null);
        }
        finally {
            connection.close();
        }
    }

    int getNbColumns() {
        String selectedRequestName = this.getSelectedRequestName();
        if (this.database == Database.ORACLE && "oracle.statistics".equals(selectedRequestName)) {
            return 2;
        }
        if (this.database == Database.ORACLE && "oracle.events".equals(selectedRequestName)) {
            return 2;
        }
        if (this.database == Database.MYSQL && "mysql.variables".equals(selectedRequestName)) {
            return 2;
        }
        if (this.database == Database.MYSQL && "mysql.global_status".equals(selectedRequestName)) {
            return 4;
        }
        return 1;
    }

    int getSelectedRequestIndex() {
        return this.selectedRequestIndex;
    }

    String getSelectedRequestName() {
        return this.requestNames.get(this.getSelectedRequestIndex());
    }

    String[][] getResult() {
        return this.result;
    }

    List<String> getRequestNames() {
        return this.requestNames;
    }

    private static String[][] executeRequest(Connection connection, String request, List<?> parametersValues) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(request);
        try {
            if (parametersValues != null) {
                int i = 1;
                for (Object parameterValue : parametersValues) {
                    statement.setObject(i, parameterValue);
                    ++i;
                }
            }
            String[][] i = DatabaseInformations.executeQuery(statement);
            return i;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 942 && e.getMessage() != null && e.getMessage().startsWith("ORA-")) {
                String userName = connection.getMetaData().getUserName();
                SQLException ex = DatabaseInformations.createGrantException(userName, e);
                throw ex;
            }
            throw e;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[][] executeQuery(PreparedStatement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery();
        try {
            int i;
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            ArrayList<String[]> list = new ArrayList<String[]>();
            String[] values = new String[columnCount];
            for (i = 1; i <= columnCount; ++i) {
                values[i - 1] = metaData.getColumnName(i) + '\n' + metaData.getColumnTypeName(i) + '(' + metaData.getColumnDisplaySize(i) + ')';
            }
            list.add(values);
            while (resultSet.next()) {
                values = new String[columnCount];
                for (i = 1; i <= columnCount; ++i) {
                    values[i - 1] = resultSet.getString(i);
                }
                list.add(values);
            }
            String[][] stringArray = (String[][])list.toArray((T[])new String[list.size()][]);
            return stringArray;
        }
        finally {
            resultSet.close();
        }
    }

    private static SQLException createGrantException(String userName, SQLException e) {
        SQLException ex = new SQLException(I18N.getFormattedString("oracle.grantSelectAnyDictionnary", userName));
        ex.initCause(e);
        return ex;
    }

    private static Connection getConnection() throws SQLException, NamingException {
        JdbcDriver jdbcDriver = JdbcDriver.SINGLETON;
        if (jdbcDriver.getLastConnectUrl() != null) {
            Connection connection = DriverManager.getConnection(jdbcDriver.getLastConnectUrl(), jdbcDriver.getLastConnectInfo());
            connection.setAutoCommit(false);
            return connection;
        }
        Collection<DataSource> dataSources = JdbcWrapperHelper.getDataSources().values();
        if (!dataSources.isEmpty()) {
            Connection connection = dataSources.iterator().next().getConnection();
            connection.setAutoCommit(false);
            return connection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String explainPlanFor(String sqlRequest) throws SQLException, NamingException {
        block7: {
            Connection connection = DatabaseInformations.getConnection();
            if (connection != null) {
                try {
                    Database database = Database.getDatabaseForConnection(connection);
                    if (database != Database.ORACLE) break block7;
                    String statementId = String.valueOf(sqlRequest.hashCode());
                    String explainRequest = DatabaseInformations.buildExplainRequest(sqlRequest, statementId);
                    Statement statement = connection.createStatement();
                    try {
                        statement.execute(explainRequest);
                    }
                    finally {
                        statement.close();
                    }
                    String string = DatabaseInformations.getPlanOutput(connection, statementId);
                    return string;
                }
                finally {
                    connection.rollback();
                    connection.close();
                }
            }
        }
        return null;
    }

    private static String buildExplainRequest(String sqlRequest, String statementId) {
        int i = 1;
        String explainRequest = "explain plan set statement_id = '" + statementId + "' for " + sqlRequest;
        int index = explainRequest.indexOf(63);
        while (index != -1) {
            explainRequest = explainRequest.substring(0, index) + ':' + i + explainRequest.substring(index + 1);
            ++i;
            index = explainRequest.indexOf(63);
        }
        return explainRequest;
    }

    private static String getPlanOutput(Connection connection, String statementId) throws SQLException {
        String planTableRequest = "select * from table(dbms_xplan.display(null,?, null))";
        String[][] planTableOutput = DatabaseInformations.executeRequest(connection, "select * from table(dbms_xplan.display(null,?, null))", Collections.singletonList(statementId));
        StringBuilder sb = new StringBuilder();
        String[][] arr$ = planTableOutput;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] row;
            for (String value : row = arr$[i$]) {
                sb.append(value);
            }
            sb.append('\n');
        }
        if (sb.indexOf("-") != -1) {
            sb.delete(0, sb.indexOf("-"));
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Database {
        POSTGRESQL,
        MYSQL,
        ORACLE,
        DB2,
        H2;

        private static final String RESOURCE_BUNDLE_BASE_NAME;

        List<String> getRequestNames() {
            List<String> tmp;
            switch (this) {
                case POSTGRESQL: {
                    tmp = Arrays.asList("pg_stat_activity", "pg_locks", "pg_database", "pg_tablespace", "pg_stat_database", "pg_stat_user_tables", "pg_stat_user_indexes", "pg_statio_user_tables", "pg_statio_user_indexes", "pg_statio_user_sequences", "pg_settings");
                    break;
                }
                case MYSQL: {
                    tmp = Arrays.asList("processlist", "databases", "variables", "global_status", "innodb_status");
                    break;
                }
                case ORACLE: {
                    tmp = Arrays.asList("sessions", "locks", "sqlTimes", "instance", "database", "nlsParameters", "tablespaceFreespace", "datafileIo", "tablespaceExtents", "ratios", "parameters", "rollbackSegmentStatistics", "statistics", "events");
                    break;
                }
                case DB2: {
                    tmp = Arrays.asList("current_queries");
                    break;
                }
                case H2: {
                    tmp = Arrays.asList("memory");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ArrayList<String> result = new ArrayList<String>(tmp.size());
            String prefix = this.toString().toLowerCase(Locale.getDefault()) + '.';
            for (String requestName : tmp) {
                result.add(prefix + requestName);
            }
            return result;
        }

        String getRequestByName(String requestName) {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME).getString(requestName);
        }

        static Database getDatabaseForConnection(Connection connection) throws SQLException {
            String url = connection.getMetaData().getURL();
            for (Database database : Database.values()) {
                if (!url.contains(database.toString().toLowerCase(Locale.getDefault()))) continue;
                return database;
            }
            throw new IllegalArgumentException(I18N.getFormattedString("type_base_de_donnees_inconnu", url));
        }

        static {
            RESOURCE_BUNDLE_BASE_NAME = Parameters.getResourcePath("databaseInformations").replace('/', '.').substring(1);
        }
    }
}

