/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import net.bull.javamelody.JdbcWrapper;

public class JdbcDriver
implements Driver {
    static final JdbcDriver SINGLETON = new JdbcDriver();
    private String lastConnectUrl;
    private Properties lastConnectInfo;

    void deregister() {
        try {
            DriverManager.deregisterDriver(this);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    String getLastConnectUrl() {
        return this.lastConnectUrl;
    }

    Properties getLastConnectInfo() {
        return this.lastConnectInfo;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        String proxiedDriver = info.getProperty("driver");
        if (proxiedDriver == null) {
            return null;
        }
        try {
            Class.forName(proxiedDriver);
        }
        catch (ClassNotFoundException e) {
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        Properties tmp = (Properties)info.clone();
        tmp.remove("driver");
        this.lastConnectUrl = url;
        this.lastConnectInfo = tmp;
        return JdbcWrapper.SINGLETON.createConnectionProxy(DriverManager.getConnection(url, tmp));
    }

    public boolean acceptsURL(String url) throws SQLException {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().endsWith("dbcp.BasicDataSource")) continue;
            return false;
        }
        return true;
    }

    public int getMajorVersion() {
        return -1;
    }

    public int getMinorVersion() {
        return -1;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[lastConnectUrl=" + this.getLastConnectUrl() + ", lastConnectInfo=" + this.getLastConnectInfo() + ']';
    }

    static {
        try {
            DriverManager.registerDriver(SINGLETON);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

