/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlCacheInformationsReport {
    private final List<CacheInformations> cacheInformationsList;
    private final Writer writer;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean hitsRatioEnabled;
    private final boolean configurationEnabled;

    HtmlCacheInformationsReport(List<CacheInformations> cacheInformationsList, Writer writer) {
        assert (cacheInformationsList != null);
        assert (writer != null);
        this.cacheInformationsList = cacheInformationsList;
        this.writer = writer;
        this.hitsRatioEnabled = HtmlCacheInformationsReport.isHitsRatioEnabled(cacheInformationsList);
        this.configurationEnabled = HtmlCacheInformationsReport.isConfigurationEnabled(cacheInformationsList);
    }

    void toHtml() throws IOException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Caches#'>");
        this.write("<thead><tr><th>#Cache#</th>");
        this.write("<th class='sorttable_numeric'>#Nb_objets_en_memoire#</th>");
        this.write("<th class='sorttable_numeric'>#Nb_objets_sur_disque#</th>");
        if (this.hitsRatioEnabled) {
            this.write("<th class='sorttable_numeric'>");
            this.write(I18N.getString("Efficacite_cache_memoire").replaceAll("\n", "<br/>"));
            this.write("</th><th class='sorttable_numeric'>");
            this.write(I18N.getString("Efficacite_cache").replaceAll("\n", "<br/>"));
            this.write("</th>");
        }
        if (this.configurationEnabled) {
            this.write("<th>#Configuration#</th>");
        }
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (CacheInformations cacheInformations : this.cacheInformationsList) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeCacheInformations(cacheInformations);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
        this.write("<div align='right' class='noPrint'>");
        if (Parameters.isSystemActionsEnabled()) {
            this.writeln("<a href='?action=clear_caches' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_purge_caches") + "');\">");
            this.writeln("<img src='?resource=user-trash.png' width='18' height='18' alt=\"#Purge_caches#\" /> #Purge_caches#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writer.write("<a href='http://ehcache.sourceforge.net/apidocs/net/sf/ehcache/config/CacheConfiguration.html#field_summary'");
        this.writeln("target='_blank'>Configuration reference</a></div>");
    }

    private void writeCacheInformations(CacheInformations cacheInformations) throws IOException {
        this.write("<td>");
        this.write(cacheInformations.getName());
        String nextColumnAlignRight = "</td> <td align='right'>";
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(cacheInformations.getInMemoryObjectCount()));
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(cacheInformations.getOnDiskObjectCount()));
        if (this.hitsRatioEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getInMemoryHitsRatio()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(cacheInformations.getHitsRatio()));
        }
        if (this.configurationEnabled) {
            this.write("</td> <td>");
            this.write(cacheInformations.getConfiguration());
        }
        this.write("</td>");
    }

    static boolean isHitsRatioEnabled(List<CacheInformations> cacheInformationsList) {
        for (CacheInformations cacheInformations : cacheInformationsList) {
            if (cacheInformations.getHitsRatio() < 0 && cacheInformations.getInMemoryHitsRatio() < 0) continue;
            return true;
        }
        return false;
    }

    static boolean isConfigurationEnabled(List<CacheInformations> cacheInformationsList) {
        for (CacheInformations cacheInformations : cacheInformationsList) {
            if (cacheInformations.getConfiguration() == null) continue;
            return true;
        }
        return false;
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

