/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.bull.javamelody.Parameters;

final class I18N {
    private static final String RESOURCE_BUNDLE_BASE_NAME = Parameters.getResourcePath("translations").replace('/', '.').substring(1);
    private static final ThreadLocal<Locale> LOCALE_CONTEXT = new ThreadLocal();
    private static final boolean JAVA_16 = "1.6".compareTo(Parameters.JAVA_VERSION) < 0;

    private I18N() {
    }

    static void bindLocale(Locale locale) {
        LOCALE_CONTEXT.set(locale);
    }

    static Locale getCurrentLocale() {
        Locale currentLocale = LOCALE_CONTEXT.get();
        if (currentLocale == null) {
            return Locale.getDefault();
        }
        return currentLocale;
    }

    private static ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME, I18N.getCurrentLocale());
    }

    static void unbindLocale() {
        LOCALE_CONTEXT.remove();
    }

    static String getString(String key) {
        return I18N.getResourceBundle().getString(key);
    }

    static String getStringForJavascript(String key) {
        return I18N.javascriptEncode(I18N.getString(key));
    }

    static String getFormattedString(String key, Object ... arguments) {
        String string = I18N.getString(key).replace("'", "''");
        return new MessageFormat(string, I18N.getCurrentLocale()).format(arguments);
    }

    static String javascriptEncode(String text) {
        return text.replace("\n", "\\n").replace("\"", "\\\"").replace("'", "\\'");
    }

    static String htmlEncode(String text, boolean encodeSpace) {
        String result = text.replaceAll("[&]", "&amp;").replaceAll("[<]", "&lt;").replaceAll("[>]", "&gt;").replaceAll("[\n]", "<br/>");
        if (encodeSpace) {
            result = result.replaceAll(" ", "&nbsp;");
        }
        return result;
    }

    static void writeTo(String html, Writer writer) throws IOException {
        int index = html.indexOf(35);
        if (index == -1) {
            writer.write(html);
        } else {
            ResourceBundle resourceBundle2 = I18N.getResourceBundle();
            int begin = 0;
            while (index != -1) {
                writer.write(html, begin, index - begin);
                int nextIndex = html.indexOf(35, index + 1);
                String key = html.substring(index + 1, nextIndex);
                writer.write(resourceBundle2.getString(key));
                begin = nextIndex + 1;
                index = html.indexOf(35, begin);
            }
            writer.write(html, begin, html.length() - begin);
        }
    }

    static void writelnTo(String html, Writer writer) throws IOException {
        I18N.writeTo(html, writer);
        writer.write(10);
    }

    static DecimalFormat createIntegerFormat() {
        return new DecimalFormat("#,##0", I18N.getDecimalFormatSymbols());
    }

    static DecimalFormat createPercentFormat() {
        return new DecimalFormat("0.00", I18N.getDecimalFormatSymbols());
    }

    private static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (JAVA_16) {
            return DecimalFormatSymbols.getInstance(I18N.getCurrentLocale());
        }
        return new DecimalFormatSymbols(I18N.getCurrentLocale());
    }

    static DateFormat createDateFormat() {
        return DateFormat.getDateInstance(3, I18N.getCurrentLocale());
    }

    static DateFormat createDateAndTimeFormat() {
        return DateFormat.getDateTimeInstance(3, 3, I18N.getCurrentLocale());
    }

    static DateFormat createDurationFormat() {
        DateFormat durationFormat = DateFormat.getTimeInstance(2, Locale.FRENCH);
        durationFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return durationFormat;
    }

    static String getCurrentDate() {
        return I18N.createDateFormat().format(new Date());
    }

    static String getCurrentDateAndTime() {
        return I18N.createDateAndTimeFormat().format(new Date());
    }
}

