/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.MonitoringFilter;

public class JiraMonitoringFilter
extends MonitoringFilter {
    private static final int SYSTEM_ADMIN = 44;
    private static final String LOGGED_IN_KEY = "seraph_defaultauthenticator_user";
    private boolean jira = true;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            super.doFilter(request, response, chain);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.jira && httpRequest.getRequestURI().equals(this.getMonitoringUrl(httpRequest))) {
            try {
                Object user = JiraMonitoringFilter.getUser(httpRequest);
                if (user == null) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    String destination = this.getMonitoringUrl(httpRequest).substring(httpRequest.getContextPath().length());
                    httpResponse.sendRedirect("login.jsp?os_destination=" + destination);
                    return;
                }
                if (!JiraMonitoringFilter.hasSystemAdminPermission(user)) {
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.sendError(403, "Forbidden access");
                    return;
                }
            }
            catch (ClassNotFoundException e) {
                this.jira = false;
            }
        }
        super.doFilter(request, response, chain);
    }

    private static boolean hasSystemAdminPermission(Object user) throws ClassNotFoundException {
        if (user == null) {
            return false;
        }
        Class<?> managerFactoryClass = Class.forName("com.atlassian.jira.ManagerFactory");
        Class<?> userClass = Class.forName("com.opensymphony.user.User");
        try {
            Object permissionManager = managerFactoryClass.getMethod("getPermissionManager", new Class[0]).invoke(null, new Object[0]);
            Boolean result = (Boolean)permissionManager.getClass().getMethod("hasPermission", Integer.TYPE, userClass).invoke(permissionManager, 44, user);
            return result;
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object getUser(HttpServletRequest httpRequest) {
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(LOGGED_IN_KEY);
    }
}

