/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Locale;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.MemoryInformations;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum TransportFormat {
    SERIALIZED("application/x-java-serialized-object"),
    XML("text/xml; charset=utf-8"),
    JSON("application/json");

    private static final String NULL_VALUE = "null";
    private final String code;
    private final String mimeType;

    private TransportFormat(String mimeType) {
        this.mimeType = mimeType;
        this.code = this.toString().toLowerCase(Locale.getDefault());
    }

    static TransportFormat valueOfIgnoreCase(String transportFormat) {
        return TransportFormat.valueOf(transportFormat.toUpperCase(Locale.getDefault()).trim());
    }

    static void pump(InputStream input, OutputStream output) throws IOException {
        byte[] bytes = new byte[4096];
        int length = input.read(bytes);
        while (length != -1) {
            output.write(bytes, 0, length);
            length = input.read(bytes);
        }
    }

    String getCode() {
        return this.code;
    }

    String getMimeType() {
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSerializableTo(Serializable serializable, OutputStream output) throws IOException {
        Object nonNullSerializable = serializable == null ? NULL_VALUE : serializable;
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
        switch (this) {
            case SERIALIZED: {
                ObjectOutputStream out = new ObjectOutputStream(bufferedOutput);
                try {
                    out.writeObject(nonNullSerializable);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    out.close();
                    throw throwable;
                }
                out.close();
                break;
            }
            case XML: {
                XmlIO.writeToXml((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            case JSON: {
                XmlIO.writeToJson((Serializable)nonNullSerializable, bufferedOutput);
                break;
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Serializable readSerializableFrom(InputStream input) throws IOException, ClassNotFoundException {
        Object result;
        BufferedInputStream bufferedInput = new BufferedInputStream(input);
        switch (this) {
            case SERIALIZED: {
                ObjectInputStream in = new ObjectInputStream(bufferedInput);
                try {
                    result = in.readObject();
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                break;
            }
            case XML: {
                result = XmlIO.readFromXml(bufferedInput);
                break;
            }
            case JSON: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalStateException(this.toString());
            }
        }
        if (NULL_VALUE.equals(result)) {
            result = null;
        }
        return (Serializable)result;
    }

    private static final class XmlIO {
        private static final String XML_CHARSET_NAME = "utf-8";

        private XmlIO() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void writeToXml(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            XStream xstream = XmlIO.createXStream(false);
            CompactWriter writer = new CompactWriter((Writer)new OutputStreamWriter((OutputStream)bufferedOutput, XML_CHARSET_NAME));
            try {
                xstream.marshal((Object)serializable, (HierarchicalStreamWriter)writer);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                writer.close();
                throw throwable;
            }
            writer.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Object readFromXml(InputStream bufferedInput) throws IOException {
            Object object;
            XStream xstream = XmlIO.createXStream(false);
            InputStreamReader reader = new InputStreamReader(bufferedInput, XML_CHARSET_NAME);
            try {
                object = xstream.fromXML((Reader)reader);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void writeToJson(Serializable serializable, BufferedOutputStream bufferedOutput) throws IOException {
            XStream xstream = XmlIO.createXStream(true);
            try {
                xstream.toXML((Object)serializable, (OutputStream)bufferedOutput);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                bufferedOutput.close();
                throw throwable;
            }
            bufferedOutput.close();
        }

        private static XStream createXStream(boolean json) {
            XStream xstream;
            if (json) {
                xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
                xstream.setMode(1001);
            } else {
                xstream = new XStream();
            }
            xstream.alias("counter", Counter.class);
            xstream.alias("request", CounterRequest.class);
            xstream.alias("javaInformations", JavaInformations.class);
            xstream.alias("memoryInformations", MemoryInformations.class);
            xstream.alias("threadInformations", ThreadInformations.class);
            xstream.alias("heapHisto", HeapHistogram.class);
            xstream.alias("connectionInformations", ConnectionInformations.class);
            xstream.alias("classInfo", HeapHistogram.ClassInfo.class);
            xstream.alias("sessionInformations", SessionInformations.class);
            xstream.alias("attribute", SessionInformations.SessionAttribute.class);
            xstream.alias("cacheInformations", CacheInformations.class);
            xstream.alias("jobInformations", JobInformations.class);
            xstream.alias("counterError", CounterError.class);
            xstream.alias("processInformations", ProcessInformations.class);
            xstream.alias("databaseInformations", DatabaseInformations.class);
            MapConverter mapConverter = new MapConverter(xstream.getMapper()){

                public boolean canConvert(Class type) {
                    return true;
                }
            };
            xstream.registerLocalConverter(Counter.class, "requests", (Converter)mapConverter);
            xstream.registerLocalConverter(Counter.class, "rootCurrentContextsByThreadId", (Converter)mapConverter);
            return xstream;
        }
    }
}

